/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.pool;

import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.TraceableGenericObjectPool;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.TraceableConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.UUID;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.pool2.ObjectPool;

public class PoolableConnectionAdapter
extends PoolableConnection {
    private final String uniqueKey;
    private final TraceableGenericObjectPool tracablePool;

    public PoolableConnectionAdapter(Connection conn, ObjectPool<PoolableConnection> pool, Collection<String> disconnectionSqlCodes, boolean fastFailValidation) {
        super(conn, pool, null, disconnectionSqlCodes, fastFailValidation);
        this.tracablePool = pool instanceof TraceableGenericObjectPool ? (TraceableGenericObjectPool)pool : null;
        this.uniqueKey = UUID.randomUUID().toString();
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public synchronized void close() throws SQLException {
        block3: {
            Connection delegate = this.getInnermostDelegate();
            if (delegate instanceof TraceableConnection) {
                TraceableConnection tc = (TraceableConnection)delegate;
                tc.updateClosedState();
            }
            try {
                super.close();
            }
            catch (SQLException e) {
                if ("Already closed.".equals(e.getMessage())) break block3;
                throw e;
            }
        }
    }

    public void reallyClose() throws SQLException {
        if (this.tracablePool != null) {
            this.tracablePool.destroyObject((Object)this);
        }
        super.reallyClose();
    }
}

