/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.pool;

import com.sap.cloud.runtime.kotyo.persistence.client.pool.GenericKeyedObjectPoolAdapter;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.PoolableConnectionAdapter;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.IPoolLogger;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.PoolLogger;
import com.sap.cloud.runtime.kotyo.persistence.tomcat.config.PersistenceUtil;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DelegatingPreparedStatement;
import org.apache.commons.dbcp2.PStmtKey;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingConnection;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

public class PoolableConnectionFactoryAdapter
extends PoolableConnectionFactory {
    private IPoolLogger poolLogger = PoolLogger.getPoolLogger();
    private int holdabilityDefault = -1;

    public PoolableConnectionFactoryAdapter(ConnectionFactory connFactory) {
        super(connFactory, null);
    }

    public void activateObject(PooledObject<PoolableConnection> p) throws Exception {
        super.activateObject(p);
        PoolableConnection conn = (PoolableConnection)p.getObject();
        if (conn != null) {
            if (this.holdabilityDefault == -1) {
                this.holdabilityDefault = conn.getMetaData().getResultSetHoldability();
            }
            conn.setHoldability(this.holdabilityDefault);
        }
    }

    public PooledObject<PoolableConnection> makeObject() throws SQLException {
        Connection conn = this.getConnectionFactory().createConnection();
        if (conn == null) {
            throw new IllegalStateException("Connection factory returned null from createConnection");
        }
        try {
            this.initializeConnection(conn);
        }
        catch (SQLException sqle) {
            try {
                conn.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw sqle;
        }
        if (this.getPoolStatements()) {
            conn = new PoolingConnection(conn);
            GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
            config.setMaxTotalPerKey(-1);
            config.setBlockWhenExhausted(false);
            config.setMaxWaitMillis(0L);
            config.setMaxIdlePerKey(1);
            config.setMaxTotal(this.getMaxOpenPreparedStatements());
            config.setJmxEnabled(false);
            GenericKeyedObjectPoolAdapter stmtPool = new GenericKeyedObjectPoolAdapter((KeyedPooledObjectFactory<PStmtKey, DelegatingPreparedStatement>)((PoolingConnection)conn), config);
            ((PoolingConnection)conn).setStatementPool((KeyedObjectPool)stmtPool);
            ((PoolingConnection)conn).setCacheState(this.getCacheState());
        }
        PoolableConnectionAdapter pc = new PoolableConnectionAdapter(conn, (ObjectPool<PoolableConnection>)this.getPool(), this.getDisconnectionSqlCodes(), this.isFastFailValidation());
        pc.setCacheState(this.getCacheState());
        return new DefaultPooledObject((Object)pc);
    }

    public void validateConnection(PoolableConnection conn) throws SQLException {
        if (conn != null) {
            this.setValidationQuery(PersistenceUtil.getDBSpecificValidationQuery((Connection)conn));
        }
        try {
            super.validateConnection(conn);
        }
        catch (SQLException e) {
            if (this.poolLogger.isDebugEnabled()) {
                this.poolLogger.debug("Connection is invalid: " + e.getMessage());
            }
            throw e;
        }
        if (this.poolLogger.isDebugEnabled()) {
            this.poolLogger.debug("Connection is valid.");
        }
    }
}

