/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.pool.jmx;

import com.sap.cloud.runtime.kotyo.persistence.client.pool.jmx.IConnectionPoolJmx;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.jmx.IConnectionPoolJmxManager;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.PoolInfo;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.TraceableGenericObjectPool;
import com.sap.cloud.runtime.kotyo.persistence.tomcat.config.PersistenceUtil;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPoolJmxManager
implements IConnectionPoolJmx,
IConnectionPoolJmxManager {
    private static final Logger log = LoggerFactory.getLogger(ConnectionPoolJmxManager.class);
    private static Hashtable<String, ConnectionPoolJmxManager> instances = new Hashtable();
    private PoolInfo poolInfo = null;
    private TraceableGenericObjectPool traceableGenericObjectPool = null;

    private ConnectionPoolJmxManager(String dsName) {
        this.initJMX(dsName);
    }

    public static IConnectionPoolJmxManager getInstance(String dsName) {
        if (dsName == null || dsName.length() == 0) {
            return null;
        }
        ConnectionPoolJmxManager cpJmxManager = instances.get(dsName);
        if (cpJmxManager == null) {
            cpJmxManager = new ConnectionPoolJmxManager(dsName);
            instances.put(dsName, cpJmxManager);
        }
        return cpJmxManager;
    }

    private void initJMX(String dsName) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            String objectName = PersistenceUtil.createConnectionPoolsObjectNameString(dsName);
            mBeanServer.registerMBean(this, new ObjectName(objectName));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected PoolInfo getPoolInfo() {
        return this.poolInfo;
    }

    @Override
    public void setPoolInfo(PoolInfo poolInfo) {
        this.poolInfo = poolInfo;
    }

    protected TraceableGenericObjectPool getTraceableGenericObjectPool() {
        return this.traceableGenericObjectPool;
    }

    @Override
    public void setTraceableGenericObjectPool(TraceableGenericObjectPool traceableGenericObjectPool) {
        this.traceableGenericObjectPool = traceableGenericObjectPool;
    }

    @Override
    public int getPooledConnectionsCount() {
        return this.getPoolInfo().getPooledConnectionsCount();
    }

    @Override
    public int getBorrowedConnectionsCount() {
        return this.getPoolInfo().getBorrowedConnectionsCount();
    }

    @Override
    public int getMaxConnections() {
        return this.getTraceableGenericObjectPool().getMaxTotal();
    }

    @Override
    public boolean getTestOnReturn() {
        return this.getTraceableGenericObjectPool().getTestOnReturn();
    }

    @Override
    public void setTestOnReturn(boolean testOnReturn) {
        this.getTraceableGenericObjectPool().setTestOnReturn(testOnReturn);
    }

    @Override
    public boolean isStackTraceCollectionEnabled() {
        return this.getPoolInfo().isStackTraceCollectionEnabled();
    }

    @Override
    public void setStackTraceCollectionEnabled(boolean stackTraceCollectionEnabled) {
        this.getPoolInfo().setStackTraceCollectionEnabled(stackTraceCollectionEnabled);
    }

    @Override
    public void forceEvict() {
        long minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        this.getTraceableGenericObjectPool().setMinEvictableIdleTimeMillis(1L);
        try {
            this.getTraceableGenericObjectPool().evict();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.getTraceableGenericObjectPool().setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    @Override
    public void logConnectionPoolInfo() {
        this.getTraceableGenericObjectPool().logConnectionPoolInfo();
    }

    @Override
    public long getMinEvictableIdleTimeMillis() {
        return this.getTraceableGenericObjectPool().getMinEvictableIdleTimeMillis();
    }

    @Override
    public long getTimeBetweenEvictionRunsMillis() {
        return this.getTraceableGenericObjectPool().getTimeBetweenEvictionRunsMillis();
    }

    @Override
    public long getMaxWaitTimeMillisForBorrow() {
        return this.getTraceableGenericObjectPool().getMaxWaitMillis();
    }

    @Override
    public long getTimeouts05h() {
        return this.getPoolInfo().getTimeoutsSinceHours(5);
    }

    @Override
    public long getTimeouts24h() {
        return this.getPoolInfo().getTimeoutsSinceHours(24);
    }

    @Override
    public long getRequestedConnections05h() {
        return this.getPoolInfo().getRequestedConnectionsSinceHours(5);
    }

    @Override
    public long getRequestedConnections24h() {
        return this.getPoolInfo().getRequestedConnectionsSinceHours(24);
    }

    @Override
    public BigDecimal getAverageConnectionWaitTimeMillis() {
        return BigDecimal.valueOf(this.getPoolInfo().getAverageConnectionWaitTimeNanos() / 1000L, 3);
    }

    @Override
    public BigDecimal getMaxConnectionWaitTimeMillis() {
        return BigDecimal.valueOf(this.getPoolInfo().getMaxConnectionWaitTimeNanos() / 1000L, 3);
    }

    @Override
    public BigDecimal getMinConnectionWaitTimeMillis() {
        return BigDecimal.valueOf(this.getPoolInfo().getMinConnectionWaitTimeNanos() / 1000L, 3);
    }

    @Override
    public void resetConnectionWaitTimeStatistics() {
        this.getPoolInfo().resetConnectionWaitTimes();
    }
}

