/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.pool.trace;

import com.sap.cloud.runtime.kotyo.persistence.client.pool.PoolableConnectionAdapter;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.ConnectionInfo;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.IPoolInfo;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.IPoolLogger;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.PoolLogger;
import com.sap.cloud.runtime.kotyo.persistence.statistics.AutoResettingLongValueStatistics;
import com.sap.cloud.runtime.kotyo.persistence.statistics.HoursBasedCounter;
import com.sap.cloud.runtime.kotyo.persistence.tomcat.config.PersistenceUtil;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class PoolInfo
implements IPoolInfo {
    private static final IPoolLogger log = PoolLogger.getPoolLogger();
    private static final DateFormat DATE_TIME_WITH_MILLIS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private Map<String, ConnectionInfo> pooledObjects = new ConcurrentHashMap<String, ConnectionInfo>();
    private Map<String, ConnectionInfo> borrowedObjects = new ConcurrentHashMap<String, ConnectionInfo>();
    private GenericObjectPool pool;
    private String dsName;
    private boolean stackTraceCollectionEnabled = true;
    private HoursBasedCounter timeoutsTc = new HoursBasedCounter(24);
    private HoursBasedCounter requestedConnectionsTc = new HoursBasedCounter(24);
    private AutoResettingLongValueStatistics connectionWaitTimes = new AutoResettingLongValueStatistics(3600000L);

    public PoolInfo(GenericObjectPool pool, String dsName) {
        this.pool = pool;
        this.dsName = dsName;
        this.stackTraceCollectionEnabled = Boolean.parseBoolean(System.getProperty("com.sap.persistence.jdbc.connection.pool.stacktraces.enabled", "true"));
    }

    @Override
    public String getName() {
        return this.dsName;
    }

    @Override
    public void updateOnBorrow(Object obj) {
        String key = this.getPoolEntryKey(obj);
        ConnectionInfo info = PoolInfo.moveObject(key, this.pooledObjects, this.borrowedObjects);
        info.setId(this.getConnectionInfo(obj));
        info.setThreadName(Thread.currentThread().getName());
        info.setBorrowTime(System.currentTimeMillis());
        info.setBorrowDuration(null);
        info.setReturnTime(null);
        if (this.isStackTraceCollectionEnabled()) {
            info.setBorrowStackTrace(this.getStackTrace());
            info.setPooledStackTrace(null);
        }
        if (log.isDebugEnabled()) {
            String msg = "borrowed from pool: " + this.getConnectionInfoOnBorrow(info);
            log.debug(msg);
        }
    }

    @Override
    public void updateOnReturn(Object obj) {
        String key = this.getPoolEntryKey(obj);
        ConnectionInfo info = PoolInfo.moveObject(key, this.borrowedObjects, this.pooledObjects);
        info.setId(this.getConnectionInfo(obj));
        info.setThreadName(Thread.currentThread().getName());
        long now = System.currentTimeMillis();
        info.setReturnTime(now);
        Long borrowTime = info.getBorrowTime();
        info.setBorrowDuration(borrowTime == null ? -1L : now - borrowTime);
        if (this.isStackTraceCollectionEnabled()) {
            info.setBorrowStackTrace(null);
            info.setPooledStackTrace(this.getStackTrace());
        }
        if (log.isDebugEnabled()) {
            String msg = "returned to pool: " + this.getConnectionInfoOnReturn(info);
            log.debug(msg);
        }
    }

    @Override
    public void updateOnDestroy(Object obj) {
        String key = this.getPoolEntryKey(obj);
        if (this.pooledObjects.containsKey(key) && log.isDebugEnabled()) {
            String info = "removed from pool: " + this.getConnectionInfo(obj);
            log.debug(info);
        }
        this.pooledObjects.remove(key);
        this.borrowedObjects.remove(key);
    }

    private StackTraceElement[] getStackTrace() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            if (stackTraceElement.getClassName().startsWith("com.sap.cloud.runtime.kotyo.persistence.client.pool.trace")) continue;
            return Arrays.copyOfRange(stackTrace, i, stackTrace.length);
        }
        return stackTrace;
    }

    private static ConnectionInfo moveObject(String key, Map<String, ConnectionInfo> from, Map<String, ConnectionInfo> to) {
        ConnectionInfo info = from.remove(key);
        if (info == null) {
            info = new ConnectionInfo();
        }
        to.put(key, info);
        return info;
    }

    @Override
    public String getDump() {
        String ret = "";
        try {
            ret = "\nDatabase connection pool '" + this.dsName + "'";
            ret = ret + "\n    Pool size (max. active connections): " + this.pool.getMaxTotal();
            ret = ret + "\n    " + this.pooledObjects.size() + " Pooled/idle connection(s):\n";
            int x = 1;
            for (ConnectionInfo pc : this.pooledObjects.values()) {
                ret = ret + "      (" + x + ") " + this.getConnectionInfoOnReturn(pc) + "\n";
                ++x;
            }
            ret = ret + "    " + this.borrowedObjects.size() + " Borrowed connection(s):\n";
            int y = 1;
            for (ConnectionInfo bc : this.borrowedObjects.values()) {
                ret = ret + "      (" + y + ") " + this.getConnectionInfoOnBorrow(bc) + "\n";
                ++y;
            }
        }
        catch (Exception e) {
            log.error("Failed to collect connection pool dump", e);
        }
        return ret;
    }

    private String getConnectionInfoOnBorrow(ConnectionInfo connection) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(connection.getId());
        sb.append(", [borrowed ");
        Long borrowTime = connection.getBorrowTime();
        if (borrowTime != null) {
            this.appendTimeInfo(sb, borrowTime);
        } else {
            sb.append("<no info available>");
        }
        this.addThreadInfo(sb, connection.getThreadName(), connection.getBorrowStackTrace());
        sb.append(']');
        return sb.toString();
    }

    private String getConnectionInfoOnReturn(ConnectionInfo connection) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(connection.getId());
        sb.append(", [returned ");
        Long returnTime = connection.getReturnTime();
        if (returnTime != null) {
            this.appendTimeInfo(sb, returnTime);
        } else {
            sb.append("<no info available>");
        }
        Long bt = connection.getBorrowDuration();
        if (bt != null && bt >= 0L) {
            sb.append(" after being borrowed for ").append(PersistenceUtil.fromMsToProperUnit(bt));
        }
        this.addThreadInfo(sb, connection.getThreadName(), connection.getPooledStackTrace());
        sb.append(']');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendTimeInfo(StringBuilder sb, Long time) {
        long ms = System.currentTimeMillis() - time;
        sb.append(PersistenceUtil.fromMsToProperUnit(ms)).append(" ago at ");
        DateFormat dateFormat = DATE_TIME_WITH_MILLIS;
        synchronized (dateFormat) {
            sb.append(DATE_TIME_WITH_MILLIS.format(new Date(time)));
        }
    }

    private void addThreadInfo(StringBuilder sb, String threadName, StackTraceElement[] stackTrace) {
        sb.append(" by thread ").append(threadName);
        if (stackTrace != null) {
            sb.append(", ").append(this.getCompleteStackTraceDump(stackTrace));
        }
    }

    private String getConnectionInfo(Object bc) {
        PoolableConnection pc;
        Connection conn;
        String ret = "<?>";
        if (bc instanceof PoolableConnection && (conn = (pc = (PoolableConnection)bc).getInnermostDelegate()) != null) {
            ret = "<Id: " + Integer.toHexString(conn.hashCode()) + ">";
        }
        return ret;
    }

    private String getCompleteStackTraceDump(StackTraceElement[] stackTraceElements) {
        StringBuilder sb = new StringBuilder(4096);
        boolean first = true;
        for (StackTraceElement line : stackTraceElements) {
            if (!first) {
                sb.append("\n          ");
            }
            sb.append(line.toString());
            first = false;
        }
        return sb.toString();
    }

    public boolean isStackTraceCollectionEnabled() {
        return this.stackTraceCollectionEnabled;
    }

    public void setStackTraceCollectionEnabled(boolean stackTraceCollectionEnabled) {
        this.stackTraceCollectionEnabled = stackTraceCollectionEnabled;
    }

    private String getPoolEntryKey(Object obj) {
        String key = obj instanceof PoolableConnectionAdapter ? ((PoolableConnectionAdapter)((Object)obj)).getUniqueKey() : Integer.toString(System.identityHashCode(obj));
        return key;
    }

    @Override
    public void notifyTimeout() {
        this.timeoutsTc.add();
    }

    @Override
    public void notifyConnectionRequested() {
        this.requestedConnectionsTc.add();
    }

    public long getTimeoutsSinceHours(int hours) {
        return this.timeoutsTc.getAccumulatedCount(hours);
    }

    public long getRequestedConnectionsSinceHours(int hours) {
        return this.requestedConnectionsTc.getAccumulatedCount(hours);
    }

    @Override
    public void updateWaitTimes(long waitTimeNanos) {
        this.connectionWaitTimes.add(waitTimeNanos);
    }

    public long getAverageConnectionWaitTimeNanos() {
        return this.connectionWaitTimes.getAverageValue();
    }

    public long getMinConnectionWaitTimeNanos() {
        return this.connectionWaitTimes.getMinValue();
    }

    public long getMaxConnectionWaitTimeNanos() {
        return this.connectionWaitTimes.getMaxValue();
    }

    public void resetConnectionWaitTimes() {
        this.connectionWaitTimes.reset();
    }

    @Override
    public int getPooledConnectionsCount() {
        return this.pooledObjects.size();
    }

    @Override
    public int getBorrowedConnectionsCount() {
        return this.borrowedObjects.size();
    }

    static {
        DATE_TIME_WITH_MILLIS.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

