/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.pool.trace;

import com.sap.cloud.runtime.kotyo.persistence.client.pool.jmx.ConnectionPoolJmxManager;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.jmx.IConnectionPoolJmxManager;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.IPoolInfo;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.IPoolLogger;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.PoolInfo;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.PoolLogger;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class TraceableGenericObjectPool
extends GenericObjectPool<PoolableConnection> {
    private static final IPoolLogger log = PoolLogger.getPoolLogger();
    private static final long MIN_TIME_BETWEEN_ERROR_LOGS = 120000L;
    private IPoolInfo poolInfo;
    private long timeLastErrorLogged = 0L;

    public TraceableGenericObjectPool(PooledObjectFactory<PoolableConnection> factory, GenericObjectPoolConfig connPoolConfig, String dsName) {
        super(factory, connPoolConfig);
        this.poolInfo = new PoolInfo(this, dsName);
        IConnectionPoolJmxManager cpJmxManager = ConnectionPoolJmxManager.getInstance(dsName);
        if (cpJmxManager != null) {
            cpJmxManager.setTraceableGenericObjectPool(this);
            cpJmxManager.setPoolInfo((PoolInfo)this.poolInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolableConnection borrowObject() throws Exception {
        this.poolInfo.notifyConnectionRequested();
        try {
            PoolableConnection ret;
            long startTime = System.nanoTime();
            try {
                ret = (PoolableConnection)super.borrowObject();
            }
            finally {
                long elapsed = System.nanoTime() - startTime;
                this.poolInfo.updateWaitTimes(elapsed);
            }
            if (ret != null) {
                this.poolInfo.updateOnBorrow(ret);
            }
            return ret;
        }
        catch (Exception e) {
            long timeCurrent;
            boolean timeoutException = this.isTimeoutException(e);
            if (timeoutException) {
                this.poolInfo.notifyTimeout();
            }
            if ((timeCurrent = System.currentTimeMillis()) - this.timeLastErrorLogged > 120000L) {
                this.timeLastErrorLogged = timeCurrent;
                log.error(e.getMessage() + "\n", e);
                if (timeoutException) {
                    log.error("The connection pool '" + this.poolInfo.getName() + "' has no pooled/idle connections available for this request");
                    log.error("Check the pool information below if the application is leaking connections");
                    log.error(this.poolInfo.getDump());
                }
            } else {
                log.error(e.getMessage());
            }
            throw e;
        }
    }

    public void evict() throws Exception {
        super.evict();
        if (log.isDebugEnabled()) {
            log.debug(this.poolInfo.getDump());
        }
    }

    public void logConnectionPoolInfo() {
        log.info(this.poolInfo.getDump());
    }

    public void returnObject(PoolableConnection obj) {
        this.poolInfo.updateOnReturn(obj);
        super.returnObject((Object)obj);
    }

    public void destroyObject(Object obj) {
        this.poolInfo.updateOnDestroy(obj);
    }

    private boolean isTimeoutException(Exception e) {
        if (e instanceof NoSuchElementException) {
            String message = e.getMessage();
            return message != null && message.toLowerCase(Locale.ENGLISH).contains("timeout");
        }
        return false;
    }
}

