/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.trace;

import com.sap.cloud.runtime.kotyo.persistence.sql.trace.ITraceRecord;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.TraceRecordFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ResultSetProxy
implements InvocationHandler {
    private final ResultSet wrappedInstance;
    private final Set<String> methodsToTrace = new HashSet<String>(Arrays.asList("beforeFirst", "afterLast", "first", "last", "next", "previous", "insertRow", "updateRow", "deleteRow", "refreshRow"));

    static ResultSet createProxy(ResultSet wrappedInstance) {
        if (wrappedInstance == null) {
            return null;
        }
        ResultSetProxy resultSetProxy = new ResultSetProxy(wrappedInstance);
        return (ResultSet)Proxy.newProxyInstance(wrappedInstance.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)resultSetProxy);
    }

    private ResultSetProxy(ResultSet resultSet) {
        this.wrappedInstance = resultSet;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ITraceRecord traceRecord = null;
        if (this.shouldTrace(method)) {
            traceRecord = TraceRecordFactory.createTraceRecord();
        }
        try {
            Object object = method.invoke((Object)this.wrappedInstance, args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            if (traceRecord != null) {
                traceRecord.finish();
            }
        }
    }

    private boolean shouldTrace(Method method) {
        return this.methodsToTrace.contains(method.getName());
    }
}

