/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.trace;

import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.IPoolLogger;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.PoolLogger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;

public abstract class TraceableBase {
    private static final String MAXDB_JDBC_DRIVER_EXCEPTION = "com.sap.dbtech.jdbc.exceptions.JDBCDriverException";
    private static final String MAXDB_EXCEPTION_MESSAGE_CLOSED = "Object is closed: com.sap.dbtech.jdbc.ConnectionSapDBFinalize";
    public boolean enableExceptionInterception = true;
    private boolean broken = false;
    private final IPoolLogger poolLogger = PoolLogger.getPoolLogger();

    public TraceableBase() {
        if (Boolean.getBoolean("cpDisableNonRecoverableSQLExceptionInterception")) {
            this.enableExceptionInterception = false;
        }
    }

    protected boolean isUseDynamicProxiesEnabled() {
        return this.enableExceptionInterception;
    }

    protected <T> T createProxy(T wrappedInstance, Class<T> type) {
        Object t = Proxy.newProxyInstance(wrappedInstance.getClass().getClassLoader(), new Class[]{type}, new ProxyInvocationHandler<T>(wrappedInstance));
        return (T)t;
    }

    private boolean isNonRecoverableSQLException(Throwable e) {
        String message;
        Class<?> exceptionClass;
        if (e instanceof SQLNonTransientException || e instanceof SQLRecoverableException) {
            return true;
        }
        return e instanceof SQLException && (exceptionClass = e.getClass()) != null && MAXDB_JDBC_DRIVER_EXCEPTION.equals(exceptionClass.getName()) && (message = e.getMessage()) != null && message.contains(MAXDB_EXCEPTION_MESSAGE_CLOSED);
    }

    protected abstract void markTraceableConnectionAsBroken();

    public boolean isBroken() {
        return this.broken;
    }

    void setBroken(boolean broken) {
        this.broken = broken;
    }

    public class ProxyInvocationHandler<T>
    implements InvocationHandler {
        private final T wrappedInstance;

        public ProxyInvocationHandler(T wrappedInstance) {
            this.wrappedInstance = wrappedInstance;
        }

        public T getWrappedInstance() {
            return this.wrappedInstance;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.wrappedInstance, args);
            }
            catch (InvocationTargetException e) {
                Throwable targetException;
                if (TraceableBase.this.poolLogger.isDebugEnabled()) {
                    String methodName = method.getName();
                    int hashCode = this.wrappedInstance.hashCode();
                    String className = this.wrappedInstance.getClass().getName();
                    TraceableBase.this.poolLogger.debug("TraceableBase.Proxy.invoke: Intercepted exception in JDBC call to " + methodName + " for " + className + " (" + Integer.toHexString(hashCode) + ")");
                }
                if (TraceableBase.this.isNonRecoverableSQLException(targetException = e.getTargetException())) {
                    TraceableBase.this.poolLogger.debug("Identified as non-recoverable SQL exception");
                    TraceableBase.this.markTraceableConnectionAsBroken();
                }
                throw targetException;
            }
        }
    }
}

