/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.trace;

import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.IPoolLogger;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.PoolLogger;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.ConnectionContext;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.SqlCallable;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.TraceableBase;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.TraceableCallableStatement;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.TraceablePreparedStatement;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.TraceableStatement;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.ActionTag;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.ITraceRecord;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.SQLTracer;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.TraceRecordFactory;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class TraceableConnection
extends TraceableBase
implements Connection {
    private static final String CLOSE = "java.sql.Connection.close()";
    private static final String COMMIT = "java.sql.Connection.commit()";
    private static final String CREATE_STATEMENT = "java.sql.Connection.createStatement()";
    private static final String CREATE_STATEMENT_TYPE_CONCUR = "java.sql.Connection.createStatement(resultSetType, concurrency)";
    private static final String CREATE_STATEMENT_TYPE_CONCUR_HOLD = "java.sql.Connection.createStatement(resultSetType, concurrency, holdability)";
    private static final String NATIVE_SQL = "java.sql.Connection.nativeSQL(sql)";
    private static final String PREPARE_CALL = "java.sql.Connection.prepareCall(sql)";
    private static final String PREPARE_CALL_TYPE_CONCUR = "java.sql.Connection.prepareCall(sql, resultSetType, concurrency)";
    private static final String PREPARE_CALL_TYPE_CONCUR_HOLD = "java.sql.Connection.prepareCall(sql, resultSetType, concurrency, holdability)";
    private static final String PREPARE_STATEMENT = "java.sql.Connection.prepareStatement(sql)";
    private static final String PREPARE_STATEMENT_COLUMNINDEXES = "java.sql.Connection.prepareStatement(sql, columnIndexes)";
    private static final String PREPARE_STATEMENT_COLUMNNAMES = "java.sql.Connection.prepareStatement(sql, columnNames)";
    private static final String PREPARE_STATEMENT_GENKEY = "java.sql.Connection.prepareStatement(sql, autoGeneratedKeys)";
    private static final String PREPARE_STATEMENT_TYPE_CONCUR = "java.sql.Connection.prepareStatement(sql, resultSetType, concurrency)";
    private static final String PREPARE_STATEMENT_TYPE_CONCUR_HOLD = "java.sql.Connection.prepareStatement(sql, resultSetType, concurrency, holdability)";
    private static final String ROLLBACK = "java.sql.Connection.rollback()";
    private static final String SET_CATALOG = "java.sql.Connection.setCatalog(catalog)";
    private static final String SET_TYPE_MAP = "java.sql.Connection.setTypeMap(map)";
    private final SQLTracer tracer;
    private final ConnectionContext context;
    private final Connection wrappedInstance;
    private final IPoolLogger poolLogger;
    private boolean closed = false;

    public TraceableConnection(SQLTracer tracer, ConnectionContext context, Connection wrappedInstance) {
        this.tracer = tracer;
        this.context = context;
        this.wrappedInstance = this.isUseDynamicProxiesEnabled() ? this.createProxy(wrappedInstance, Connection.class) : wrappedInstance;
        this.poolLogger = PoolLogger.getPoolLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.wrappedInstance.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.wrappedInstance.isWrapperFor(iface);
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement stmt = this.executeTraced(CREATE_STATEMENT, false, new SqlCallable<Statement>(){

            @Override
            public Statement call() throws SQLException {
                return TraceableConnection.this.wrappedInstance.createStatement();
            }
        });
        return new TraceableStatement(this.tracer, this, stmt);
    }

    @Override
    public PreparedStatement prepareStatement(final String sql) throws SQLException {
        PreparedStatement stmt = this.executeTraced(PREPARE_STATEMENT, false, new SqlCallable<PreparedStatement>(){

            @Override
            public PreparedStatement call() throws SQLException {
                return TraceableConnection.this.wrappedInstance.prepareStatement(sql);
            }
        });
        return new TraceablePreparedStatement(this.tracer, this, stmt, sql);
    }

    @Override
    public CallableStatement prepareCall(final String sql) throws SQLException {
        CallableStatement stmt = this.executeTraced(PREPARE_CALL, false, new SqlCallable<CallableStatement>(){

            @Override
            public CallableStatement call() throws SQLException {
                return TraceableConnection.this.wrappedInstance.prepareCall(sql);
            }
        });
        return new TraceableCallableStatement(this.tracer, this, stmt, sql);
    }

    @Override
    public String nativeSQL(final String sql) throws SQLException {
        return this.executeTraced(NATIVE_SQL, false, new SqlCallable<String>(){

            @Override
            public String call() throws SQLException {
                return TraceableConnection.this.wrappedInstance.nativeSQL(sql);
            }
        });
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.wrappedInstance.getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.wrappedInstance.setAutoCommit(autoCommit);
    }

    @Override
    public void commit() throws SQLException {
        this.executeTraced(COMMIT, true, new SqlCallable<Void>(){

            @Override
            public Void call() throws SQLException {
                TraceableConnection.this.wrappedInstance.commit();
                return null;
            }
        });
    }

    @Override
    public void rollback() throws SQLException {
        this.executeTraced(ROLLBACK, true, new SqlCallable<Void>(){

            @Override
            public Void call() throws SQLException {
                TraceableConnection.this.wrappedInstance.rollback();
                return null;
            }
        });
    }

    @Override
    public void close() throws SQLException {
        this.executeTraced(CLOSE, true, new SqlCallable<Void>(){

            @Override
            public Void call() throws SQLException {
                TraceableConnection.this.closed = true;
                TraceableConnection.this.wrappedInstance.close();
                return null;
            }
        });
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.wrappedInstance.getMetaData();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.wrappedInstance.isReadOnly();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.wrappedInstance.setReadOnly(readOnly);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.wrappedInstance.getCatalog();
    }

    @Override
    public void setCatalog(final String catalog) throws SQLException {
        this.executeTraced(SET_CATALOG, false, new SqlCallable<Void>(){

            @Override
            public Void call() throws SQLException {
                TraceableConnection.this.wrappedInstance.setCatalog(catalog);
                return null;
            }
        });
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.wrappedInstance.getTransactionIsolation();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.wrappedInstance.setTransactionIsolation(level);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.wrappedInstance.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.wrappedInstance.clearWarnings();
    }

    @Override
    public Statement createStatement(final int resultSetType, final int resultSetConcurrency) throws SQLException {
        Statement stmt = this.executeTraced(CREATE_STATEMENT_TYPE_CONCUR, false, new SqlCallable<Statement>(){

            @Override
            public Statement call() throws SQLException {
                return TraceableConnection.this.wrappedInstance.createStatement(resultSetType, resultSetConcurrency);
            }
        });
        return new TraceableStatement(this.tracer, this, stmt);
    }

    @Override
    public PreparedStatement prepareStatement(final String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
        PreparedStatement stmt = this.executeTraced(PREPARE_STATEMENT_TYPE_CONCUR, false, new SqlCallable<PreparedStatement>(){

            @Override
            public PreparedStatement call() throws SQLException {
                return TraceableConnection.this.wrappedInstance.prepareStatement(sql, resultSetType, resultSetConcurrency);
            }
        });
        return new TraceablePreparedStatement(this.tracer, this, stmt, sql);
    }

    @Override
    public CallableStatement prepareCall(final String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
        CallableStatement stmt = this.executeTraced(PREPARE_CALL_TYPE_CONCUR, false, new SqlCallable<CallableStatement>(){

            @Override
            public CallableStatement call() throws SQLException {
                return TraceableConnection.this.wrappedInstance.prepareCall(sql, resultSetType, resultSetConcurrency);
            }
        });
        return new TraceableCallableStatement(this.tracer, this, stmt, sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.wrappedInstance.getTypeMap();
    }

    @Override
    public void setTypeMap(final Map<String, Class<?>> map) throws SQLException {
        this.executeTraced(SET_TYPE_MAP, false, new SqlCallable<Void>(){

            @Override
            public Void call() throws SQLException {
                TraceableConnection.this.wrappedInstance.setTypeMap(map);
                return null;
            }
        });
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.wrappedInstance.getHoldability();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.wrappedInstance.setHoldability(holdability);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.wrappedInstance.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.wrappedInstance.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.wrappedInstance.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.wrappedInstance.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        Statement stmt = this.executeTraced(CREATE_STATEMENT_TYPE_CONCUR_HOLD, false, new SqlCallable<Statement>(){

            @Override
            public Statement call() throws SQLException {
                return TraceableConnection.this.wrappedInstance.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            }
        });
        return new TraceableStatement(this.tracer, this, stmt);
    }

    @Override
    public PreparedStatement prepareStatement(final String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        PreparedStatement stmt = this.executeTraced(PREPARE_STATEMENT_TYPE_CONCUR_HOLD, false, new SqlCallable<PreparedStatement>(){

            @Override
            public PreparedStatement call() throws SQLException {
                return TraceableConnection.this.wrappedInstance.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
        });
        return new TraceablePreparedStatement(this.tracer, this, stmt, sql);
    }

    @Override
    public CallableStatement prepareCall(final String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        CallableStatement stmt = this.executeTraced(PREPARE_CALL_TYPE_CONCUR_HOLD, false, new SqlCallable<CallableStatement>(){

            @Override
            public CallableStatement call() throws SQLException {
                return TraceableConnection.this.wrappedInstance.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
        });
        return new TraceableCallableStatement(this.tracer, this, stmt, sql);
    }

    @Override
    public PreparedStatement prepareStatement(final String sql, final int autoGeneratedKeys) throws SQLException {
        PreparedStatement stmt = this.executeTraced(PREPARE_STATEMENT_GENKEY, false, new SqlCallable<PreparedStatement>(){

            @Override
            public PreparedStatement call() throws SQLException {
                return TraceableConnection.this.wrappedInstance.prepareStatement(sql, autoGeneratedKeys);
            }
        });
        return new TraceablePreparedStatement(this.tracer, this, stmt, sql);
    }

    @Override
    public PreparedStatement prepareStatement(final String sql, final int[] columnIndexes) throws SQLException {
        PreparedStatement stmt = this.executeTraced(PREPARE_STATEMENT_COLUMNINDEXES, false, new SqlCallable<PreparedStatement>(){

            @Override
            public PreparedStatement call() throws SQLException {
                return TraceableConnection.this.wrappedInstance.prepareStatement(sql, columnIndexes);
            }
        });
        return new TraceablePreparedStatement(this.tracer, this, stmt, sql);
    }

    @Override
    public PreparedStatement prepareStatement(final String sql, final String[] columnNames) throws SQLException {
        PreparedStatement stmt = this.executeTraced(PREPARE_STATEMENT_COLUMNNAMES, false, new SqlCallable<PreparedStatement>(){

            @Override
            public PreparedStatement call() throws SQLException {
                return TraceableConnection.this.wrappedInstance.prepareStatement(sql, columnNames);
            }
        });
        return new TraceablePreparedStatement(this.tracer, this, stmt, sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.wrappedInstance.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.wrappedInstance.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.wrappedInstance.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.wrappedInstance.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.wrappedInstance.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.wrappedInstance.setClientInfo(name, value);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.wrappedInstance.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.wrappedInstance.getClientInfo();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.wrappedInstance.setClientInfo(properties);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.wrappedInstance.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.wrappedInstance.createStruct(typeName, attributes);
    }

    ConnectionContext getContext() {
        return this.context;
    }

    public void updateClosedState() {
        block9: {
            if (this.isBroken()) {
                this.closed = true;
                if (this.poolLogger.isDebugEnabled()) {
                    this.poolLogger.debug("TraceableConnection.updateClosedState: connection <Id: " + Integer.toHexString(this.hashCode()) + "> is broken");
                }
                return;
            }
            if (this.isUseDynamicProxiesEnabled() && this.context.isMaxDB()) {
                return;
            }
            try {
                if (this.wrappedInstance.isClosed()) {
                    this.closed = true;
                    if (this.poolLogger.isDebugEnabled()) {
                        this.poolLogger.debug(this.getPoolDebugString("true"));
                    }
                } else if (this.poolLogger.isDebugEnabled()) {
                    this.poolLogger.debug(this.getPoolDebugString("false"));
                }
            }
            catch (SQLException e) {
                this.closed = true;
                if (!this.poolLogger.isDebugEnabled()) break block9;
                this.poolLogger.debug(e.getMessage(), e);
            }
        }
    }

    @Override
    protected void markTraceableConnectionAsBroken() {
        this.setBroken(true);
        if (this.poolLogger.isDebugEnabled()) {
            this.poolLogger.debug("TraceableConnection.markTraceableConnectionAsBroken: Marked connection " + Integer.toHexString(this.hashCode()) + " as broken");
        }
    }

    private String getPoolDebugString(String closedState) {
        return "TraceableConnection.updateClosedState: connection <Id: " + Integer.toHexString(this.hashCode()) + "> isClosed() returned " + closedState;
    }

    @Override
    public String getSchema() throws SQLException {
        return this.wrappedInstance.getSchema();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.wrappedInstance.setSchema(schema);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.wrappedInstance.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.wrappedInstance.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.wrappedInstance.getNetworkTimeout();
    }

    private <T> T executeTraced(String method, boolean callsDB, SqlCallable<T> callable) throws SQLException {
        T result;
        boolean debugEnabled = this.tracer.isDebugEnabled();
        if (debugEnabled) {
            this.tracer.debug(this.tracer.formatSQLTraceMessage(method, ActionTag.BEFORE_METHOD_CALL, this.context.getConnectionID(), null));
        }
        ITraceRecord traceRecord = TraceRecordFactory.createTraceRecord(callsDB);
        try {
            result = callable.call();
        }
        catch (SQLException ex) {
            if (debugEnabled) {
                this.tracer.debug(this.tracer.formatSQLTraceMessage(method, ActionTag.EXCEPTION_OCCURRED, this.context.getConnectionID(), null), ex);
            }
            throw ex;
        }
        finally {
            traceRecord.finish();
        }
        if (debugEnabled) {
            this.tracer.debug(this.tracer.formatSQLTraceMessage(method, ActionTag.METHOD_CALLED_SUCCESS, this.context.getConnectionID(), null, traceRecord));
        }
        return result;
    }
}

