/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.trace;

import com.sap.cloud.runtime.kotyo.persistence.client.trace.ConnectionContext;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.TraceableConnection;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.ActionTag;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.ITraceRecord;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.SQLTracer;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.TraceRecordFactory;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.impl.SQLTracerImpl;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class TraceableDataSource
implements DataSource {
    private static final String MAXDB_DATASOURCE = "com.sap.dbtech.jdbcext.DataSourceSapDB";
    private static final String GET_CONNECTION = "javax.sql.DataSource.getConnection()";
    private static final String GET_CONNECTION_USER_PW = "javax.sql.DataSource.getConnection(user, password)";
    private final SQLTracer tracer = new SQLTracerImpl();
    private final DataSource wrappedInstance;
    private boolean isMaxDB = false;

    public TraceableDataSource(DataSource wrappedInstance) {
        this.wrappedInstance = wrappedInstance;
        Class<?> dataSourceClass = wrappedInstance.getClass();
        if (dataSourceClass != null && MAXDB_DATASOURCE.equals(dataSourceClass.getName())) {
            this.isMaxDB = true;
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.wrappedInstance.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.wrappedInstance.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.wrappedInstance.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.wrappedInstance.getLoginTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.wrappedInstance.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.wrappedInstance.isWrapperFor(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection;
        if (this.tracer.isDebugEnabled()) {
            this.tracer.debug(this.tracer.formatSQLTraceMessage(GET_CONNECTION, ActionTag.BEFORE_METHOD_CALL));
        }
        ITraceRecord traceRecord = TraceRecordFactory.createTraceRecord();
        try {
            connection = this.wrappedInstance.getConnection();
        }
        catch (SQLException ex) {
            if (this.tracer.isDebugEnabled()) {
                this.tracer.debug(this.tracer.formatSQLTraceMessage(GET_CONNECTION, ActionTag.EXCEPTION_OCCURRED), ex);
            }
            throw ex;
        }
        finally {
            traceRecord.finish();
        }
        TraceableConnection wrapper = this.createTraceableConnection(connection);
        if (this.tracer.isDebugEnabled()) {
            this.tracer.debug(this.tracer.formatSQLTraceMessage(GET_CONNECTION, ActionTag.METHOD_CALLED_SUCCESS, wrapper.getContext().getConnectionID(), null, traceRecord));
        }
        return wrapper;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection connection;
        if (this.tracer.isDebugEnabled()) {
            this.tracer.debug(this.tracer.formatSQLTraceMessage(GET_CONNECTION_USER_PW, ActionTag.BEFORE_METHOD_CALL));
        }
        ITraceRecord traceRecord = TraceRecordFactory.createTraceRecord();
        try {
            connection = this.wrappedInstance.getConnection(username, password);
        }
        catch (SQLException ex) {
            if (this.tracer.isDebugEnabled()) {
                this.tracer.debug(this.tracer.formatSQLTraceMessage(GET_CONNECTION_USER_PW, ActionTag.EXCEPTION_OCCURRED), ex);
            }
            throw ex;
        }
        finally {
            traceRecord.finish();
        }
        TraceableConnection wrapper = this.createTraceableConnection(connection);
        if (this.tracer.isDebugEnabled()) {
            this.tracer.debug(this.tracer.formatSQLTraceMessage(GET_CONNECTION_USER_PW, ActionTag.METHOD_CALLED_SUCCESS, wrapper.getContext().getConnectionID(), null, traceRecord));
        }
        return wrapper;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.wrappedInstance.getParentLogger();
    }

    private TraceableConnection createTraceableConnection(Connection wrappedInstance) {
        String connectionId = this.getConnectionId(wrappedInstance);
        ConnectionContext context = new ConnectionContext(connectionId, this.isMaxDB);
        return new TraceableConnection(this.tracer, context, wrappedInstance);
    }

    private String getConnectionId(Connection connection) {
        return Integer.toHexString(System.identityHashCode(connection));
    }
}

