/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.trace;

import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.PoolLogger;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.ResultSetProxy;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.SqlCallable;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.TraceableConnection;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.TraceableStatement;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.ActionTag;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.SQLTracer;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

class TraceablePreparedStatement
extends TraceableStatement
implements PreparedStatement {
    private static final String ADD_BATCH = "java.sql.PreparedStatement.addBatch()";
    private static final String EXECUTE = "java.sql.PreparedStatement.execute()";
    private static final String EXECUTE_QUERY = "java.sql.PreparedStatement.executeQuery()";
    private static final String EXECUTE_UPDATE = "java.sql.PreparedStatement.executeUpdate()";
    private final PreparedStatement wrappedInstance;
    private final String preparedSql;

    TraceablePreparedStatement(SQLTracer tracer, TraceableConnection connection, PreparedStatement wrappedInstance, String preparedSql) throws SQLException {
        super(tracer, connection, wrappedInstance);
        this.wrappedInstance = this.isUseDynamicProxiesEnabled() ? this.createProxy(wrappedInstance, PreparedStatement.class) : wrappedInstance;
        this.preparedSql = preparedSql;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ResultSet rs = this.executeTraced(EXECUTE_QUERY, this.preparedSql, new SqlCallable<ResultSet>(){

            @Override
            public ResultSet call() throws SQLException {
                return TraceablePreparedStatement.this.wrappedInstance.executeQuery();
            }
        });
        return ResultSetProxy.createProxy(rs);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeTraced(EXECUTE_UPDATE, this.preparedSql, new SqlCallable<Integer>(){

            @Override
            public Integer call() throws SQLException {
                return TraceablePreparedStatement.this.wrappedInstance.executeUpdate();
            }
        });
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.wrappedInstance.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.wrappedInstance.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.wrappedInstance.setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.wrappedInstance.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.wrappedInstance.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.wrappedInstance.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.wrappedInstance.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.wrappedInstance.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.wrappedInstance.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.wrappedInstance.setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.wrappedInstance.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.wrappedInstance.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.wrappedInstance.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.wrappedInstance.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.wrappedInstance.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.wrappedInstance.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.wrappedInstance.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.wrappedInstance.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.wrappedInstance.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.wrappedInstance.setObject(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeTraced(EXECUTE, this.preparedSql, new SqlCallable<Boolean>(){

            @Override
            public Boolean call() throws SQLException {
                return TraceablePreparedStatement.this.wrappedInstance.execute();
            }
        });
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.tracer.isDebugEnabled()) {
            this.tracer.debug(this.tracer.formatSQLTraceMessage(ADD_BATCH, ActionTag.BEFORE_METHOD_CALL, this.connection.getContext().getConnectionID(), this.preparedSql));
        }
        try {
            this.wrappedInstance.addBatch();
        }
        catch (SQLException ex) {
            if (this.tracer.isDebugEnabled()) {
                this.tracer.debug(this.tracer.formatSQLTraceMessage(ADD_BATCH, ActionTag.EXCEPTION_OCCURRED, this.connection.getContext().getConnectionID(), this.preparedSql), ex);
            }
            throw ex;
        }
        if (this.tracer.isDebugEnabled()) {
            this.tracer.debug(this.tracer.formatSQLTraceMessage(ADD_BATCH, ActionTag.METHOD_CALLED_SUCCESS, this.connection.getContext().getConnectionID(), null));
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.wrappedInstance.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.wrappedInstance.setRef(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.wrappedInstance.setBlob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.wrappedInstance.setClob(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.wrappedInstance.setArray(parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.wrappedInstance.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.wrappedInstance.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.wrappedInstance.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.wrappedInstance.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.wrappedInstance.setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.wrappedInstance.setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.wrappedInstance.getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.wrappedInstance.setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.wrappedInstance.setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.wrappedInstance.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.wrappedInstance.setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.wrappedInstance.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.wrappedInstance.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.wrappedInstance.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.wrappedInstance.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.wrappedInstance.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.wrappedInstance.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.wrappedInstance.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.wrappedInstance.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.wrappedInstance.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.wrappedInstance.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.wrappedInstance.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.wrappedInstance.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.wrappedInstance.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.wrappedInstance.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.wrappedInstance.setNClob(parameterIndex, reader);
    }

    @Override
    protected void handleException(SQLException ex) {
        if ("JZ0F2".equals(ex.getSQLState()) || "ZZZZZ".equals(ex.getSQLState()) && ex.getErrorCode() == 590 && Boolean.valueOf(System.getProperty("com.sap.core.persistence.enableASEHACheck", "true")).booleanValue()) {
            this.setBroken(true);
            PoolLogger.getPoolLogger().info("Detected ASE HA failover");
        }
    }
}

