/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.trace;

import com.sap.cloud.runtime.kotyo.persistence.client.trace.ResultSetProxy;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.SqlCallable;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.TraceableBase;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.TraceableConnection;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.ActionTag;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.ITraceRecord;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.SQLTracer;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.TraceRecordFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class TraceableStatement
extends TraceableBase
implements Statement {
    private static final String ADD_BATCH = "java.sql.Statement.addBatch(sql)";
    private static final String EXECUTE = "java.sql.Statement.execute(sql)";
    private static final String EXECUTE_COLUMNINDEXES = "java.sql.Statement.execute(sql, columnIndexes)";
    private static final String EXECUTE_COLUMNNAMES = "java.sql.Statement.execute(sql, columnNames)";
    private static final String EXECUTE_GENKEY = "java.sql.Statement.execute(sql, autoGeneratedKeys)";
    private static final String EXECUTE_BATCH = "java.sql.Statement.executeBatch()";
    private static final String EXECUTE_QUERY = "java.sql.Statement.executeQuery(sql)";
    private static final String EXECUTE_UPDATE = "java.sql.Statement.executeUpdate(sql)";
    private static final String EXECUTE_UPDATE_COLUMNINDEXES = "java.sql.Statement.executeUpdate(sql, columnIndexes)";
    private static final String EXECUTE_UPDATE_COLUMNNAMES = "java.sql.Statement.executeUpdate(sql, columnNames)";
    private static final String EXECUTE_UPDATE_GENKEY = "java.sql.Statement.executeUpdate(sql, autoGeneratedKeys)";
    protected final SQLTracer tracer;
    protected final TraceableConnection connection;
    private final Statement wrappedInstance;
    private final int initialMaxRows;
    private final int initialMaxFieldSize;
    private final int initialFetchSize;
    private final int initialFetchDirection;
    private final int initialQueryTimeout;

    TraceableStatement(SQLTracer tracer, TraceableConnection connection, Statement wrappedInstance) throws SQLException {
        this.tracer = tracer;
        this.connection = connection;
        this.wrappedInstance = this.isUseDynamicProxiesEnabled() ? this.createProxy(wrappedInstance, Statement.class) : wrappedInstance;
        this.initialMaxRows = wrappedInstance.getMaxRows();
        this.initialMaxFieldSize = wrappedInstance.getMaxFieldSize();
        this.initialFetchSize = wrappedInstance.getFetchSize();
        this.initialFetchDirection = wrappedInstance.getFetchDirection();
        this.initialQueryTimeout = wrappedInstance.getQueryTimeout();
    }

    @Override
    public ResultSet executeQuery(final String sql) throws SQLException {
        ResultSet rs = this.executeTraced(EXECUTE_QUERY, sql, new SqlCallable<ResultSet>(){

            @Override
            public ResultSet call() throws SQLException {
                return TraceableStatement.this.wrappedInstance.executeQuery(sql);
            }
        });
        return ResultSetProxy.createProxy(rs);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.wrappedInstance.unwrap(iface);
    }

    @Override
    public int executeUpdate(final String sql) throws SQLException {
        return this.executeTraced(EXECUTE_UPDATE, sql, new SqlCallable<Integer>(){

            @Override
            public Integer call() throws SQLException {
                return TraceableStatement.this.wrappedInstance.executeUpdate(sql);
            }
        });
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.wrappedInstance.isWrapperFor(iface);
    }

    @Override
    public void close() throws SQLException {
        this.wrappedInstance.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.wrappedInstance.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.wrappedInstance.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.wrappedInstance.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.wrappedInstance.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.wrappedInstance.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.wrappedInstance.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.wrappedInstance.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.wrappedInstance.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.wrappedInstance.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.wrappedInstance.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.wrappedInstance.setCursorName(name);
    }

    @Override
    public boolean execute(final String sql) throws SQLException {
        return this.executeTraced(EXECUTE, sql, new SqlCallable<Boolean>(){

            @Override
            public Boolean call() throws SQLException {
                return TraceableStatement.this.wrappedInstance.execute(sql);
            }
        });
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet rs = this.wrappedInstance.getResultSet();
        return ResultSetProxy.createProxy(rs);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.wrappedInstance.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.wrappedInstance.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.wrappedInstance.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.wrappedInstance.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.wrappedInstance.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.wrappedInstance.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.wrappedInstance.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.wrappedInstance.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.tracer.isDebugEnabled()) {
            this.tracer.debug(this.tracer.formatSQLTraceMessage(ADD_BATCH, ActionTag.BEFORE_METHOD_CALL, this.connection.getContext().getConnectionID(), sql));
        }
        try {
            this.wrappedInstance.addBatch(sql);
        }
        catch (SQLException ex) {
            if (this.tracer.isDebugEnabled()) {
                this.tracer.debug(this.tracer.formatSQLTraceMessage(ADD_BATCH, ActionTag.EXCEPTION_OCCURRED, this.connection.getContext().getConnectionID(), sql), ex);
            }
            throw ex;
        }
        if (this.tracer.isDebugEnabled()) {
            this.tracer.debug(this.tracer.formatSQLTraceMessage(ADD_BATCH, ActionTag.METHOD_CALLED_SUCCESS, this.connection.getContext().getConnectionID(), null));
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.wrappedInstance.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.executeTraced(EXECUTE_BATCH, null, new SqlCallable<int[]>(){

            @Override
            public int[] call() throws SQLException {
                return TraceableStatement.this.wrappedInstance.executeBatch();
            }
        });
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.wrappedInstance.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.wrappedInstance.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        ResultSet rs = this.wrappedInstance.getGeneratedKeys();
        return ResultSetProxy.createProxy(rs);
    }

    @Override
    public int executeUpdate(final String sql, final int autoGeneratedKeys) throws SQLException {
        return this.executeTraced(EXECUTE_UPDATE_GENKEY, sql, new SqlCallable<Integer>(){

            @Override
            public Integer call() throws SQLException {
                return TraceableStatement.this.wrappedInstance.executeUpdate(sql, autoGeneratedKeys);
            }
        });
    }

    @Override
    public int executeUpdate(final String sql, final int[] columnIndexes) throws SQLException {
        return this.executeTraced(EXECUTE_UPDATE_COLUMNINDEXES, sql, new SqlCallable<Integer>(){

            @Override
            public Integer call() throws SQLException {
                return TraceableStatement.this.wrappedInstance.executeUpdate(sql, columnIndexes);
            }
        });
    }

    @Override
    public int executeUpdate(final String sql, final String[] columnNames) throws SQLException {
        return this.executeTraced(EXECUTE_UPDATE_COLUMNNAMES, sql, new SqlCallable<Integer>(){

            @Override
            public Integer call() throws SQLException {
                return TraceableStatement.this.wrappedInstance.executeUpdate(sql, columnNames);
            }
        });
    }

    @Override
    public boolean execute(final String sql, final int autoGeneratedKeys) throws SQLException {
        return this.executeTraced(EXECUTE_GENKEY, sql, new SqlCallable<Boolean>(){

            @Override
            public Boolean call() throws SQLException {
                return TraceableStatement.this.wrappedInstance.execute(sql, autoGeneratedKeys);
            }
        });
    }

    @Override
    public boolean execute(final String sql, final int[] columnIndexes) throws SQLException {
        return this.executeTraced(EXECUTE_COLUMNINDEXES, sql, new SqlCallable<Boolean>(){

            @Override
            public Boolean call() throws SQLException {
                return TraceableStatement.this.wrappedInstance.execute(sql, columnIndexes);
            }
        });
    }

    @Override
    public boolean execute(final String sql, final String[] columnNames) throws SQLException {
        return this.executeTraced(EXECUTE_COLUMNNAMES, sql, new SqlCallable<Boolean>(){

            @Override
            public Boolean call() throws SQLException {
                return TraceableStatement.this.wrappedInstance.execute(sql, columnNames);
            }
        });
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.wrappedInstance.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.wrappedInstance.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.wrappedInstance.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.wrappedInstance.isPoolable();
    }

    @Override
    protected void markTraceableConnectionAsBroken() {
        this.connection.markTraceableConnectionAsBroken();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.wrappedInstance.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.wrappedInstance.isCloseOnCompletion();
    }

    protected <T> T executeTraced(String method, String text, SqlCallable<T> callable) throws SQLException {
        T result;
        boolean debugEnabled = this.tracer.isDebugEnabled();
        if (debugEnabled) {
            this.tracer.debug(this.tracer.formatSQLTraceMessage(method, ActionTag.BEFORE_METHOD_CALL, this.connection.getContext().getConnectionID(), text));
        }
        ITraceRecord traceRecord = TraceRecordFactory.createTraceRecord(true);
        try {
            result = callable.call();
        }
        catch (SQLException ex) {
            if (debugEnabled) {
                this.tracer.debug(this.tracer.formatSQLTraceMessage(method, ActionTag.EXCEPTION_OCCURRED, this.connection.getContext().getConnectionID(), text), ex);
            }
            this.handleException(ex);
            throw ex;
        }
        finally {
            traceRecord.finish();
        }
        if (debugEnabled) {
            this.tracer.debug(this.tracer.formatSQLTraceMessage(method, ActionTag.METHOD_CALLED_SUCCESS, this.connection.getContext().getConnectionID(), null, traceRecord));
        }
        return result;
    }

    protected void handleException(SQLException ex) {
    }

    public void reset() throws SQLException {
        this.wrappedInstance.setMaxRows(this.initialMaxRows);
        this.wrappedInstance.setMaxFieldSize(this.initialMaxFieldSize);
        this.wrappedInstance.setFetchSize(this.initialFetchSize);
        this.wrappedInstance.setFetchDirection(this.initialFetchDirection);
        this.wrappedInstance.setQueryTimeout(this.initialQueryTimeout);
        this.wrappedInstance.clearWarnings();
    }
}

