/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.json;

import com.sap.cloud.runtime.kotyo.persistence.json.JsonLexerConsumer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

class ConfigContentConsumer
implements JsonLexerConsumer {
    private Properties properties;
    private State state = State.INITIAL;
    private List<Integer> contentList = new ArrayList<Integer>();

    ConfigContentConsumer() {
    }

    @Override
    public void beginObject() {
        if (this.state != State.INITIAL) {
            throw new IllegalStateException("nested objects");
        }
        this.state = State.OBJECT_STARTED;
    }

    @Override
    public void endObject() {
        if (this.state != State.ENTRY_COMPLETE) {
            throw new IllegalStateException("Unexpected end of object");
        }
    }

    @Override
    public void colon() {
        if (this.state == State.KEY_READ) {
            this.state = State.EXPECTING_VALUE;
        } else if (this.state == State.CONTENT_FOUND) {
            this.state = State.EXPECT_CONTENT_ARRAY;
        } else {
            throw new IllegalStateException("Unexpected colon");
        }
    }

    @Override
    public void comma() {
        if (this.state == State.ENTRY_COMPLETE) {
            this.state = State.OBJECT_STARTED;
        } else if (this.state != State.CONTENT_READ) {
            throw new IllegalStateException("Unexpected comma");
        }
    }

    @Override
    public void number(Number number) {
        if (this.state == State.CONTENT_READ) {
            this.contentList.add(number.intValue());
        } else if (this.state == State.EXPECTING_VALUE) {
            this.state = State.ENTRY_COMPLETE;
        } else {
            throw new IllegalStateException("Unexpected number");
        }
    }

    @Override
    public void string(String s) {
        if (this.state == State.OBJECT_STARTED) {
            this.state = "content".equals(s) ? State.CONTENT_FOUND : State.KEY_READ;
        } else if (this.state == State.EXPECTING_VALUE) {
            this.state = State.ENTRY_COMPLETE;
        } else {
            throw new IllegalStateException("Unexpected string " + s);
        }
    }

    @Override
    public void finish() {
        byte[] contentData = new byte[this.contentList.size()];
        for (int i = 0; i < contentData.length; ++i) {
            int j = this.contentList.get(i);
            contentData[i] = (byte)j;
        }
        this.contentList.clear();
        this.properties = new Properties();
        try {
            this.properties.load(new ByteArrayInputStream(contentData));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load properties from byte array", e);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void beginArray() {
        if (this.state != State.EXPECT_CONTENT_ARRAY) {
            throw new IllegalStateException("Unexpected array data");
        }
        this.state = State.CONTENT_READ;
    }

    @Override
    public void endArray() {
        if (this.state != State.CONTENT_READ) {
            throw new IllegalStateException("Unexpected end of array.");
        }
        this.state = State.ENTRY_COMPLETE;
    }

    @Override
    public void isTrue() {
    }

    @Override
    public void isFalse() {
    }

    @Override
    public void isNull() {
    }

    static enum State {
        INITIAL,
        OBJECT_STARTED,
        KEY_READ,
        EXPECTING_VALUE,
        CONTENT_FOUND,
        EXPECT_CONTENT_ARRAY,
        CONTENT_READ,
        ENTRY_COMPLETE;

    }
}

