/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.json;

import com.sap.cloud.runtime.kotyo.persistence.json.JsonException;
import com.sap.cloud.runtime.kotyo.persistence.json.JsonLexerConsumer;
import java.io.IOException;
import java.io.Reader;

class JsonLexer {
    private final Reader reader;
    private final JsonLexerConsumer consumer;
    private Integer pushback;

    JsonLexer(Reader reader, JsonLexerConsumer consumer) {
        this.reader = reader;
        this.consumer = consumer;
    }

    public void parse() throws IOException {
        char c;
        block14: while (true) {
            int r;
            if ((r = this.read()) == -1) {
                this.consumer.finish();
                return;
            }
            c = (char)r;
            switch (c) {
                case '\"': {
                    this.consumer.string(this.readString());
                    continue block14;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block14;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.consumer.number(this.readNumber(c));
                    continue block14;
                }
                case ':': {
                    this.consumer.colon();
                    continue block14;
                }
                case ',': {
                    this.consumer.comma();
                    continue block14;
                }
                case '{': {
                    this.consumer.beginObject();
                    continue block14;
                }
                case '}': {
                    this.consumer.endObject();
                    continue block14;
                }
                case '[': {
                    this.consumer.beginArray();
                    continue block14;
                }
                case ']': {
                    this.consumer.endArray();
                    continue block14;
                }
                case 't': {
                    this.readTrue();
                    this.consumer.isTrue();
                    continue block14;
                }
                case 'f': {
                    this.readFalse();
                    this.consumer.isFalse();
                    continue block14;
                }
                case 'n': {
                    this.readNull();
                    this.consumer.isNull();
                    continue block14;
                }
            }
            break;
        }
        throw new JsonException("Unexpected character '" + c + "'");
    }

    private void readNull() throws IOException {
        this.assertExpectation(this.reader.read(), 'u');
        this.assertExpectation(this.reader.read(), 'l');
        this.assertExpectation(this.reader.read(), 'l');
    }

    private void assertExpectation(int read, char expected) {
        if ((char)read != expected) {
            throw new JsonException("Failed to read json, expected '" + expected + "' but got '" + read + "'");
        }
    }

    private void readFalse() throws IOException {
        this.assertExpectation(this.reader.read(), 'a');
        this.assertExpectation(this.reader.read(), 'l');
        this.assertExpectation(this.reader.read(), 's');
        this.assertExpectation(this.reader.read(), 'e');
    }

    private void readTrue() throws IOException {
        this.assertExpectation(this.reader.read(), 'r');
        this.assertExpectation(this.reader.read(), 'u');
        this.assertExpectation(this.reader.read(), 'e');
    }

    private String readString() throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        boolean loop = true;
        block13: while (loop) {
            char c = this.readOrFail();
            if (escape) {
                escape = false;
                switch (c) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        sb.append(c);
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'u': {
                        sb.append(this.readHexChar());
                    }
                }
                continue;
            }
            switch (c) {
                case '\\': {
                    escape = true;
                    continue block13;
                }
                case '\"': {
                    loop = false;
                    continue block13;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private int read() throws IOException {
        if (this.pushback != null) {
            int r = this.pushback;
            this.pushback = null;
            return r;
        }
        return this.reader.read();
    }

    private char readOrFail() throws IOException {
        int r = this.read();
        if (r == -1) {
            throw new IOException("Unexpected end of input");
        }
        return (char)r;
    }

    private char readHexChar() throws IOException {
        char[] chars = new char[4];
        for (int i = 0; i < 4; ++i) {
            chars[i] = this.readOrFail();
        }
        return (char)Integer.parseInt(new String(chars), 16);
    }

    private Number readNumber(char c) throws IOException {
        int r;
        StringBuilder sb = new StringBuilder();
        sb.append(c);
        boolean loop = true;
        block7: while (loop) {
            r = this.read();
            if (r == -1) {
                return Long.parseLong(sb.toString());
            }
            c = (char)r;
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    sb.append(c);
                    continue block7;
                }
                case '.': 
                case 'E': 
                case 'e': {
                    loop = false;
                    continue block7;
                }
            }
            this.pushback = r;
            return Long.parseLong(sb.toString());
        }
        sb.append(c);
        block8: while (true) {
            if ((r = this.read()) == -1) {
                return Double.parseDouble(sb.toString());
            }
            c = (char)r;
            switch (c) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'E': 
                case 'e': {
                    sb.append(c);
                    continue block8;
                }
            }
            break;
        }
        this.pushback = r;
        return Double.parseDouble(sb.toString());
    }
}

