/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.manageddatasource;

import com.sap.cloud.runtime.kotyo.persistence.client.PersistenceDataSourceFactory;
import com.sap.cloud.runtime.kotyo.persistence.unmanageddatasource.AbstractContext;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedDatasourcesContext
extends AbstractContext {
    private static final Logger logger = LoggerFactory.getLogger(ManagedDatasourcesContext.class);

    protected ManagedDatasourcesContext(Hashtable<?, ?> environment) {
        super(environment);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        DataSource dataSource = this.get(name);
        if (dataSource != null) {
            return dataSource;
        }
        int pos = name.indexOf(58);
        String path = pos < 0 ? name : name.substring(pos + 1);
        Reference r = new Reference(DataSource.class.getName());
        Object objectInstance = null;
        try {
            objectInstance = this.getPersistenceDataSourceFactory().getObjectInstance(r, new CompositeName(path), this, this.getEnvironment());
        }
        catch (RuntimeException e) {
            logger.error("Failed to create managed datasource for '" + name + "'", (Throwable)e);
            throw e;
        }
        catch (NamingException e) {
            logger.debug("Failed to create managed datasource for '" + name + "'", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Failed to create managed datasource for '" + name + "'", (Throwable)e);
        }
        if (objectInstance instanceof DataSource) {
            dataSource = (DataSource)objectInstance;
            this.bind(name, (Object)dataSource);
            return dataSource;
        }
        return null;
    }

    protected ObjectFactory getPersistenceDataSourceFactory() {
        return new PersistenceDataSourceFactory();
    }
}

