/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.sql.trace;

import com.sap.cloud.runtime.kotyo.persistence.jdsr.config.JdsrBeanProvider;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.ITraceRecord;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.TraceRecordImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceRecordFactory {
    private static Logger SQL_TRACE_LOGGER = LoggerFactory.getLogger((String)"com.sap.core.persistence.sql.trace");

    public static ITraceRecord createTraceRecord() {
        return TraceRecordFactory.createTraceRecord(false);
    }

    public static ITraceRecord createTraceRecord(boolean callsDB) {
        if (TraceRecordFactory.isRecordingRequired()) {
            return new TraceRecordImpl(callsDB);
        }
        return new NoOpTraceRecord();
    }

    private static boolean isRecordingRequired() {
        return SQL_TRACE_LOGGER.isDebugEnabled() || JdsrBeanProvider.getDbStatisticsProvider().isEnabled();
    }

    private static class NoOpTraceRecord
    implements ITraceRecord {
        private NoOpTraceRecord() {
        }

        @Override
        public void finish() {
        }

        @Override
        public long getExecutionTime() {
            return 0L;
        }

        @Override
        public long getNetworkTraffic() {
            return 0L;
        }
    }
}

