/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.sql.trace;

import com.sap.cloud.runtime.kotyo.persistence.jdsr.config.JdsrBeanProvider;
import com.sap.cloud.runtime.kotyo.persistence.jdsr.config.JdsrStatisticsBean;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.ITraceRecord;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.impl.NetworkIO;

public class TraceRecordImpl
implements ITraceRecord {
    private final long startTime;
    private final long bytesRead;
    private final long bytesWritten;
    private final boolean callsDB;
    private long executionTime;
    private long networkTraffic;
    private static NetworkIO networkIO = NetworkIO.getInstance();

    TraceRecordImpl(boolean callsDB) {
        this.callsDB = callsDB;
        this.startTime = System.nanoTime();
        this.bytesRead = networkIO.getBytesRead();
        this.bytesWritten = networkIO.getBytesWritten();
    }

    @Override
    public void finish() {
        JdsrStatisticsBean provider = JdsrBeanProvider.getDbStatisticsProvider();
        this.executionTime = System.nanoTime() - this.startTime;
        provider.addDbTime(this.executionTime);
        if (this.callsDB) {
            provider.increaseDbCalls();
        }
        long read = networkIO.getBytesRead() - this.bytesRead;
        provider.setDbInputBytes((int)(read + (long)provider.getDbInputBytes()));
        long written = networkIO.getBytesWritten() - this.bytesWritten;
        provider.setDbOutputBytes((int)(written + (long)provider.getDbOutputBytes()));
        this.networkTraffic = read + written;
    }

    @Override
    public long getExecutionTime() {
        return this.executionTime;
    }

    @Override
    public long getNetworkTraffic() {
        return this.networkTraffic;
    }
}

