/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.sql.trace.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetworkIO {
    static Logger logger = LoggerFactory.getLogger((String)"com.sap.core.persistence.sql.trace");
    private static NetworkIO instance;

    public static NetworkIO getInstance() {
        if (instance == null) {
            instance = NetworkIO.createInstance();
        }
        return instance;
    }

    private static NetworkIO createInstance() {
        NetworkIO result = null;
        if (Boolean.getBoolean("disableDatabaseNetworkTrafficMonitoring")) {
            logger.trace("Network I/O tracing is disabled by system property");
        } else if (System.getProperty("java.vm.vendor").contains("SAP")) {
            try {
                Class.forName("com.sap.jvm.monitor.vm.VmInfo");
                try {
                    Class<?> networkIO = Class.forName("com.sap.cloud.runtime.kotyo.persistence.sql.trace.impl.SAPJVMNetworkIO");
                    result = (NetworkIO)networkIO.newInstance();
                }
                catch (Exception e) {
                    logger.warn("Failed to enable network I/O tracing", (Throwable)e);
                }
            }
            catch (ClassNotFoundException e) {
                logger.trace("SAP JVM monitor support is not available, network I/O tracing is disabled", (Throwable)e);
            }
        } else {
            logger.trace("No SAP JVM, network I/O tracing is disabled");
        }
        if (result == null) {
            result = new DummyNetworkIO();
        }
        return result;
    }

    public abstract long getBytesRead();

    public abstract long getBytesWritten();

    static class DummyNetworkIO
    extends NetworkIO {
        DummyNetworkIO() {
        }

        @Override
        public long getBytesRead() {
            return 0L;
        }

        @Override
        public long getBytesWritten() {
            return 0L;
        }
    }
}

