/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.sql.trace.impl;

import com.sap.cloud.runtime.kotyo.persistence.sql.trace.impl.NetworkIO;
import com.sap.jvm.monitor.vm.VmInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SAPJVMNetworkIO
extends NetworkIO {
    private final Method threadNetworkTraffic;
    private boolean enabled = true;
    private final long[] nullResult = new long[]{0L, 0L};

    public SAPJVMNetworkIO() throws NoSuchMethodException {
        this.threadNetworkTraffic = VmInfo.class.getDeclaredMethod("getCurrentThreadNetworkTraffic", new Class[0]);
    }

    @Override
    public long getBytesRead() {
        return this.getData()[0];
    }

    @Override
    public long getBytesWritten() {
        return this.getData()[1];
    }

    private long[] getData() {
        if (this.enabled) {
            try {
                return (long[])this.threadNetworkTraffic.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.error("Failed to read network traffic from SAP JVM, network traffic monitoring will be disabled", (Throwable)e);
                this.enabled = false;
            }
        }
        return this.nullResult;
    }
}

