/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.sql.trace.impl;

import com.sap.cloud.runtime.kotyo.persistence.sql.trace.ActionTag;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.ITraceRecord;
import com.sap.cloud.runtime.kotyo.persistence.sql.trace.SQLTracer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLTracerImpl
implements SQLTracer {
    private static final String LOG_PART_SEPARATOR = " - ";
    private static final Logger logger = LoggerFactory.getLogger((String)"com.sap.core.persistence.sql.trace");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final DateFormat TIME_WITH_MILLIS = new SimpleDateFormat("HH:mm:ss.SSS");

    @Override
    public boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    @Override
    public void debug(String message) {
        logger.debug(message);
    }

    @Override
    public void debug(String message, Exception exception) {
        if (exception == null) {
            logger.debug(message);
        } else {
            StringBuilder sb = new StringBuilder(2048);
            sb.append(message);
            sb.append(LINE_SEPARATOR);
            sb.append("\t");
            sb.append(SQLTracerImpl.getStackTraceAsString(exception));
            logger.debug(sb.toString());
        }
    }

    @Override
    public String formatSQLTraceMessage(String callingMethod, ActionTag actionTag, String connectionId, String SQL) {
        return this.formatSQLTraceMessage(callingMethod, actionTag, connectionId, SQL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String formatSQLTraceMessage(String callingMethod, ActionTag actionTag, String connectionId, String SQL, ITraceRecord record) {
        StringBuilder sb = new StringBuilder(800);
        DateFormat dateFormat = TIME_WITH_MILLIS;
        synchronized (dateFormat) {
            sb.append(TIME_WITH_MILLIS.format(new Date()));
        }
        sb.append(LOG_PART_SEPARATOR);
        sb.append(System.nanoTime());
        sb.append(LOG_PART_SEPARATOR);
        sb.append(callingMethod);
        if (actionTag != null) {
            sb.append(LOG_PART_SEPARATOR);
            sb.append(actionTag.getTextRepresentation());
        }
        if (connectionId != null) {
            sb.append(LOG_PART_SEPARATOR);
            sb.append("conn=[");
            sb.append(connectionId);
            sb.append(']');
        }
        if (SQL != null) {
            sb.append(LOG_PART_SEPARATOR);
            sb.append("SQL=\"");
            sb.append(SQL);
            sb.append("\"");
        }
        if (record != null) {
            long networkTraffic;
            long duration = record.getExecutionTime();
            if (duration >= 0L) {
                sb.append(LOG_PART_SEPARATOR);
                sb.append("Request duration = ");
                sb.append(this.getDurationString(duration));
            }
            if ((networkTraffic = record.getNetworkTraffic()) >= 0L) {
                sb.append(LOG_PART_SEPARATOR);
                sb.append("Network traffic = ");
                sb.append(networkTraffic);
                sb.append(" bytes");
            }
        }
        return sb.toString();
    }

    @Override
    public String formatSQLTraceMessage(String callingMethod, ActionTag actionTag) {
        return this.formatSQLTraceMessage(callingMethod, actionTag, null, null);
    }

    private static String getStackTraceAsString(Exception exception) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        exception.printStackTrace(printWriter);
        return result.toString();
    }

    private String getDurationString(long durationInNanos) {
        NumberFormat format = NumberFormat.getInstance(Locale.US);
        format.setGroupingUsed(true);
        format.setMinimumIntegerDigits(1);
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(3);
        String duration = format.format((double)durationInNanos / 1000.0);
        return duration + "\u00b5s";
    }

    static {
        TIME_WITH_MILLIS.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

