/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.statistics;

import com.sap.cloud.runtime.kotyo.persistence.statistics.LongValueStatistics;
import java.util.concurrent.atomic.AtomicLong;

public class AutoResettingLongValueStatistics
extends LongValueStatistics {
    private final long resetInterval;
    private final AtomicLong lastReset = new AtomicLong(System.currentTimeMillis());

    public AutoResettingLongValueStatistics(long resetIntervalMillis) {
        this.resetInterval = resetIntervalMillis;
    }

    @Override
    public void add(long value) {
        if (this.resetTimerIfNeeded()) {
            super.reset();
        }
        super.add(value);
    }

    @Override
    public void reset() {
        this.resetTimer();
        super.reset();
    }

    public long getLastReset() {
        return this.lastReset.get();
    }

    private boolean resetTimerIfNeeded() {
        long now;
        long lastTime;
        do {
            lastTime = this.lastReset.get();
            now = System.currentTimeMillis();
            if (now - lastTime >= this.resetInterval) continue;
            return false;
        } while (!this.lastReset.compareAndSet(lastTime, now));
        return true;
    }

    private void resetTimer() {
        long now;
        long lastTime;
        while (!this.lastReset.compareAndSet(lastTime = this.lastReset.get(), now = System.currentTimeMillis())) {
        }
    }
}

