/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.statistics;

public class HoursBasedCounter {
    private final long[] counters;
    private int pointer;
    private long lastUpdate;
    private ITimeProvider timeProvider;

    public HoursBasedCounter(int forHours) {
        this.counters = new long[forHours];
        this.pointer = 0;
        this.timeProvider = new DefaultTimeProvider();
        this.lastUpdate = this.timeProvider.getTime();
    }

    public synchronized void add() {
        this.update();
        int n = this.pointer;
        this.counters[n] = this.counters[n] + 1L;
    }

    public synchronized long getCurrentCounter() {
        this.update();
        return this.counters[this.pointer];
    }

    public synchronized long getAccumulatedCount(int forHours) {
        if (forHours > this.counters.length) {
            throw new IllegalArgumentException("Parameter 'forHours' must not be greater than the history size: was: " + forHours + ", max is: " + this.counters.length);
        }
        long result = this.getCurrentCounter();
        int index = this.pointer;
        for (int i = 1; i < forHours; ++i) {
            if (--index < 0) {
                index = this.counters.length - 1;
            }
            result += this.counters[index];
        }
        return result;
    }

    private void update() {
        long currentTime = this.timeProvider.getTime();
        int currentHour = (int)(currentTime / 1000L / 60L / 60L);
        int lastUpdateHour = (int)(this.lastUpdate / 1000L / 60L / 60L);
        this.lastUpdate = this.timeProvider.getTime();
        int delta = currentHour - lastUpdateHour;
        for (int i = 1; i <= delta; ++i) {
            ++this.pointer;
            if (this.pointer == this.counters.length) {
                this.pointer = 0;
            }
            this.counters[this.pointer] = 0L;
        }
    }

    public void setTimeProvider(ITimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        this.lastUpdate = timeProvider.getTime();
    }

    private class DefaultTimeProvider
    implements ITimeProvider {
        @Override
        public long getTime() {
            return System.currentTimeMillis();
        }
    }

    public static interface ITimeProvider {
        public long getTime();
    }
}

