/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.statistics;

import java.util.concurrent.atomic.AtomicReference;

public class LongValueStatistics {
    private final AtomicReference<Entry> values = new AtomicReference<Entry>(new Entry());

    public long getAccumulatedValue() {
        return this.values.get().accValue;
    }

    public long getNumValues() {
        return this.values.get().numValues;
    }

    public long getAverageValue() {
        Entry current = this.values.get();
        if (current.numValues == 0L) {
            return 0L;
        }
        return current.accValue / current.numValues;
    }

    public long getMinValue() {
        Entry current = this.values.get();
        if (current.minValue == Long.MAX_VALUE) {
            return 0L;
        }
        return current.minValue;
    }

    public long getMaxValue() {
        Entry current = this.values.get();
        if (current.maxValue == Long.MIN_VALUE) {
            return 0L;
        }
        return current.maxValue;
    }

    public void add(long value) {
        long newMax;
        long newMin;
        Entry newEntry;
        Entry oldEntry;
        while (!this.values.compareAndSet(oldEntry = this.values.get(), newEntry = new Entry(oldEntry.accValue + value, oldEntry.numValues + 1L, newMin = value < oldEntry.minValue ? value : oldEntry.minValue, newMax = value > oldEntry.maxValue ? value : oldEntry.maxValue))) {
        }
    }

    public void reset() {
        Entry newEntry;
        Entry oldEntry;
        while (!this.values.compareAndSet(oldEntry = this.values.get(), newEntry = new Entry())) {
        }
    }

    private static class Entry {
        final long accValue;
        final long numValues;
        final long minValue;
        final long maxValue;

        public Entry(long accumulatedValue, long numValues, long minValue, long maxValue) {
            this.accValue = accumulatedValue;
            this.numValues = numValues;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public Entry() {
            this(0L, 0L, Long.MAX_VALUE, Long.MIN_VALUE);
        }
    }
}

