/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.statistics;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;

public class TimeCollector {
    private long lastCleanUp = -1L;
    private long maxTimeMillis;
    private CopyOnWriteArrayList<Long> timeList = new CopyOnWriteArrayList();

    public TimeCollector(int hours, int minutes) {
        this((hours * 60 + minutes) * 60 * 1000);
    }

    private TimeCollector(long maxTimeMillis) {
        this.maxTimeMillis = maxTimeMillis;
        this.updateCleanUpTime();
    }

    public void addToCollector() {
        long now = System.currentTimeMillis();
        if (this.lastCleanUp < now - 3600000L) {
            this.cleanUp();
            this.updateCleanUpTime();
        }
        this.timeList.add(now);
    }

    public int getCountForTimeHours(int hours) {
        return this.getCountForTimeMinutes(hours * 60);
    }

    public int getCountForTimeMinutes(int minutes) {
        return this.getCountForTimeSeconds(minutes * 60);
    }

    public int getCountForTimeSeconds(long seconds) {
        return this.getCountForTimeMillis(seconds * 1000L);
    }

    private int getCountForTimeMillis(long timeMillis) {
        ArrayList<Long> removeList = new ArrayList<Long>();
        if (timeMillis > this.maxTimeMillis) {
            throw new IllegalArgumentException("timeMillis must not be higher than maxTimeMillis");
        }
        int ret = 0;
        long now = System.currentTimeMillis();
        for (Long entry : this.timeList) {
            if (now - entry <= timeMillis) {
                ++ret;
            }
            if (now - entry <= this.maxTimeMillis) continue;
            removeList.add(entry);
        }
        for (Long r : removeList) {
            this.timeList.remove(r);
        }
        this.updateCleanUpTime();
        return ret;
    }

    private void cleanUp() {
        ArrayList<Long> removeList = new ArrayList<Long>();
        long now = System.currentTimeMillis();
        for (Long entry : this.timeList) {
            if (now - entry <= this.maxTimeMillis) continue;
            removeList.add(entry);
        }
        for (Long r : removeList) {
            this.timeList.remove(r);
        }
    }

    private void updateCleanUpTime() {
        this.lastCleanUp = System.currentTimeMillis();
    }
}

