/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.tomcat.config;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class PersistenceUtil {
    private static final String PERSISTENCE = "Persistence";
    private static final String CONNECTION_POOLS = "Persistence-ConnectionPools";
    public static final String NO_INFO_AVAILABLE = "<no info available>";

    private static String createPreObjectName(String typeName) {
        return "com.sap.cloud.jmx:type=" + typeName + ",name=";
    }

    public static String getDBSpecificValidationQuery(Connection conn) throws SQLException {
        String ret = null;
        DatabaseMetaData databaseMetaData = conn.getMetaData();
        String databaseProductName = databaseMetaData.getDatabaseProductName();
        if ("ApacheDerby".equals(databaseProductName)) {
            ret = "VALUES 1";
        } else if ("HDB".equals(databaseProductName)) {
            ret = "SELECT 1 FROM DUMMY";
        } else if ("SAP DB".equals(databaseProductName)) {
            ret = "SELECT 1 FROM DUAL";
        }
        return ret;
    }

    public static String fromNanosToProperUnit(long nanos) {
        if (nanos >= 1000000L) {
            long ms = Math.round((double)nanos / 1000000.0);
            return PersistenceUtil.fromMsToProperUnit(ms);
        }
        if (nanos >= 1000L) {
            return Math.round((double)nanos / 1000.0) + " mikros";
        }
        return nanos + " nanos";
    }

    public static String fromMsToProperUnit(long ms) {
        if (ms >= 60000L) {
            return Math.round((double)ms / 60000.0) + " min";
        }
        if (ms >= 1000L) {
            return Math.round((double)ms / 1000.0) + " s";
        }
        return ms + " ms";
    }

    public static String createPersistenceObjectNameString(String name) {
        return PersistenceUtil.createPreObjectName(PERSISTENCE) + name;
    }

    public static String createConnectionPoolsObjectNameString(String name) {
        return PersistenceUtil.createPreObjectName(CONNECTION_POOLS) + name;
    }
}

