/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.unmanageddatasource;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.sql.DataSource;

public abstract class AbstractContext
implements Context {
    private final Map<String, DataSource> bindings;
    private Hashtable environment = new Hashtable();

    public AbstractContext(Hashtable<?, ?> environment) {
        if (environment != null) {
            Enumeration<?> envEntries = environment.keys();
            while (envEntries.hasMoreElements()) {
                Object o = envEntries.nextElement();
                this.environment.put(o, environment.get(o));
            }
        }
        this.bindings = new HashMap<String, DataSource>();
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        String key = this.toString(name);
        return this.lookup(key);
    }

    @Override
    public abstract Object lookup(String var1) throws NamingException;

    protected DataSource get(String name) {
        return this.bindings.get(name);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(this.toString(name), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        if (!(obj instanceof DataSource)) {
            throw new NamingException("This context can only bind datasources");
        }
        this.bindings.put(name, (DataSource)obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(this.toString(name));
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.bindings.remove(name);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name prefixClone = (Name)prefix.clone();
        return prefixClone.addAll(name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return prefix + "/" + name;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    private String toString(Name name) {
        StringBuilder sb = new StringBuilder();
        Enumeration<String> all = name.getAll();
        while (all.hasMoreElements()) {
            String s = all.nextElement();
            sb.append("/");
            sb.append(s);
        }
        if (sb.length() == 0) {
            throw new IllegalStateException("Empty name is not valid");
        }
        return sb.toString().substring(1);
    }
}

