/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.MsgObject;
import java.util.HashMap;

public class Category
extends LogController {
    public static final String ROOT_NAME = "/";
    public static final char SEPARATOR = '/';
    public static final Category SYSTEM = Category.getCategoryInt("/System");
    public static final Category APPLICATIONS = Category.getCategoryInt("/Applications");
    public static final Category APPS_COMMON = Category.getCategory(APPLICATIONS, "Common");
    public static final Category APPS_COMMON_SECURITY = Category.getCategory(APPS_COMMON, "Security");
    public static final Category APPS_COMMON_BACKUP = Category.getCategory(APPS_COMMON, "Backup");
    public static final Category APPS_COMMON_ARCHIVING = Category.getCategory(APPS_COMMON, "Archiving");
    public static final Category APPS_COMMON_RESOURCES = Category.getCategory(APPS_COMMON, "Resources");
    public static final Category APPS_COMMON_CONFIGURATION = Category.getCategory(APPS_COMMON, "Configuration");
    public static final Category APPS_COMMON_FAILOVER = Category.getCategory(APPS_COMMON, "Failover");
    public static final Category APPS_COMMON_INFRASTRUCTURE = Category.getCategory(APPS_COMMON, "Infrastructure");
    public static final Category PERFORMANCE = Category.getCategoryInt("/Performance");
    public static final Category SYS_DATABASE = Category.getCategory(SYSTEM, "Database");
    public static final Category SYS_NETWORK = Category.getCategory(SYSTEM, "Network");
    public static final Category SYS_SERVER = Category.getCategory(SYSTEM, "Server");
    public static final Category SYS_SECURITY = Category.getCategory(SYSTEM, "Security");
    public static final Category SYS_USER_INTERFACE = Category.getCategory(SYSTEM, "UserInterface");
    public static final Category SYS_CONFIGURATION = Category.getCategory(SYSTEM, "Configuration");
    public static final Category SYS_LOGGING = Category.getCategory(SYSTEM, "Logging");
    public static final Category SYS_ENTERPRISE_SERVICES = Category.getCategory(SYSTEM, "EnterpriseServices");
    protected static final Category SYS_CONFIGURATION_LOGGING = Category.getCategory(SYS_CONFIGURATION, "Logging");
    public static final Category SYS_CHANGES = Category.getCategory(SYSTEM, "Changes");
    public static final HashMap<String, Category> PREDEF_CATEGORIES = new HashMap();
    static final String NO_LOCATION_EMSG = "no location";

    static {
        PREDEF_CATEGORIES.put(ROOT_NAME, Category.getRoot());
        PREDEF_CATEGORIES.put("/Performance", PERFORMANCE);
        PREDEF_CATEGORIES.put("/Applications", APPLICATIONS);
        PREDEF_CATEGORIES.put("/Applications/Common", APPS_COMMON);
        PREDEF_CATEGORIES.put("/Applications/Common/Security", APPS_COMMON_SECURITY);
        PREDEF_CATEGORIES.put("/Applications/Common/Backup", APPS_COMMON_BACKUP);
        PREDEF_CATEGORIES.put("/Applications/Common/Archiving", APPS_COMMON_ARCHIVING);
        PREDEF_CATEGORIES.put("/Applications/Common/Resources", APPS_COMMON_RESOURCES);
        PREDEF_CATEGORIES.put("/Applications/Common/Configuration", APPS_COMMON_CONFIGURATION);
        PREDEF_CATEGORIES.put("/Applications/Common/Failover", APPS_COMMON_FAILOVER);
        PREDEF_CATEGORIES.put("/Applications/Common/Infrastructure", APPS_COMMON_INFRASTRUCTURE);
        PREDEF_CATEGORIES.put("/System", SYSTEM);
        PREDEF_CATEGORIES.put("/System/Database", SYS_DATABASE);
        PREDEF_CATEGORIES.put("/System/Network", SYS_NETWORK);
        PREDEF_CATEGORIES.put("/System/Server", SYS_SERVER);
        PREDEF_CATEGORIES.put("/System/Security", SYS_SECURITY);
        PREDEF_CATEGORIES.put("/System/UserInterface", SYS_USER_INTERFACE);
        PREDEF_CATEGORIES.put("/System/Configuration", SYS_CONFIGURATION);
        PREDEF_CATEGORIES.put("/System/Configuration/Logging", SYS_CONFIGURATION_LOGGING);
        PREDEF_CATEGORIES.put("/System/Logging", SYS_LOGGING);
        PREDEF_CATEGORIES.put("/System/EnterpriseServices", SYS_ENTERPRISE_SERVICES);
        PREDEF_CATEGORIES.put("/System/Changes", SYS_CHANGES);
    }

    Category(String name) {
        super(name);
    }

    Category(String name, Category parent) {
        super(name, parent);
    }

    static Category getCategoryInt(String name) {
        return new Category(name.trim());
    }

    public static Category getRoot() {
        return Category.getCategoryInt(ROOT_NAME);
    }

    private static String correctCategoryName(String categoryName) {
        boolean lastNotSeparator = true;
        if ((categoryName = categoryName.trim()).length() == 0) {
            return "";
        }
        StringBuffer correctName = new StringBuffer(categoryName.length());
        int i = 0;
        while (i < categoryName.length()) {
            char currentChar = categoryName.charAt(i);
            if (currentChar != '.') {
                if (currentChar == '/') {
                    if (lastNotSeparator) {
                        correctName.append(currentChar);
                    }
                    lastNotSeparator = false;
                } else {
                    correctName.append(currentChar);
                    lastNotSeparator = true;
                }
            }
            ++i;
        }
        String finalName = correctName.toString();
        int len = finalName.length();
        if (len > 1 && finalName.charAt(len - 1) == '/') {
            finalName = finalName.substring(0, len - 1);
        }
        return finalName;
    }

    public static Category getCategory(Category category, String name) {
        String categoryName = Category.correctCategoryName(String.valueOf(category.getName()) + '/' + name);
        return Category.getCategoryInt(categoryName);
    }

    public static Category getCategory(String name) {
        return Category.getCategoryInt(Category.correctCategoryName(name));
    }

    public LogRecord logT(int severity, Location loc, String msg) {
        return loc.logInt(severity, msg);
    }

    public LogRecord logT(int severity, Location loc, String subloc, String msg) {
        return loc.logInt(severity, msg);
    }

    public LogRecord logT(int severity, Location loc, String msg, Object[] args) {
        return loc.logInt(severity, this.replaceArguments(msg, args));
    }

    public LogRecord logT(int severity, Location loc, String subloc, String msg, Object[] args) {
        return loc.logInt(severity, this.replaceArguments(msg, args));
    }

    public LogRecord log(int severity, Location loc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(severity, msgObject.getMsgText());
    }

    public LogRecord log(int severity, Location loc, String subLoc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(severity, msgObject.getMsgText());
    }

    public LogRecord log(int severity, Location loc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(severity, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord log(int severity, Location loc, String subLoc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(severity, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord infoT(Location loc, String msg) {
        return loc.logInt(300, msg);
    }

    public LogRecord infoT(Location loc, String subloc, String msg) {
        return loc.logInt(300, msg);
    }

    public LogRecord infoT(Location loc, String msg, Object[] args) {
        return loc.logInt(300, this.replaceArguments(msg, args));
    }

    public LogRecord infoT(Location loc, String subloc, String msg, Object[] args) {
        return loc.logInt(300, this.replaceArguments(msg, args));
    }

    public LogRecord info(Location loc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(300, msgObject.getMsgText());
    }

    public LogRecord info(Location loc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(300, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord info(Location loc, String subLoc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(300, msgObject.getMsgText());
    }

    public LogRecord info(Location loc, String subLoc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(300, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord warningT(Location loc, String msg) {
        return loc.logInt(400, msg);
    }

    public LogRecord warningT(Location loc, String subloc, String msg) {
        return loc.logInt(400, msg);
    }

    public LogRecord warningT(Location loc, String msg, Object[] args) {
        return loc.logInt(400, this.replaceArguments(msg, args));
    }

    public LogRecord warningT(Location loc, String subloc, String msg, Object[] args) {
        return loc.logInt(400, this.replaceArguments(msg, args));
    }

    public LogRecord warning(Location loc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(400, msgObject.getMsgText());
    }

    public LogRecord warning(Location loc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(400, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord warning(Location loc, String subLoc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(400, msgObject.getMsgText());
    }

    public LogRecord warning(Location loc, String subLoc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(400, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord errorT(Location loc, String msg) {
        return loc.logInt(500, msg);
    }

    public LogRecord errorT(Location loc, String subloc, String msg) {
        return loc.logInt(500, msg);
    }

    public LogRecord errorT(Location loc, String msg, Object[] args) {
        return loc.logInt(500, this.replaceArguments(msg, args));
    }

    public LogRecord errorT(Location loc, String subloc, String msg, Object[] args) {
        return loc.logInt(500, this.replaceArguments(msg, args));
    }

    public LogRecord error(Location loc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(500, msgObject.getMsgText());
    }

    public LogRecord error(Location loc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(500, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord error(Location loc, String subLoc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(500, msgObject.getMsgText());
    }

    public LogRecord error(Location loc, String subLoc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(500, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord fatalT(Location loc, String msg) {
        return loc.logInt(600, msg);
    }

    public LogRecord fatalT(Location loc, String subloc, String msg) {
        return loc.logInt(600, msg);
    }

    public LogRecord fatalT(Location loc, String msg, Object[] args) {
        return loc.logInt(600, this.replaceArguments(msg, args));
    }

    public LogRecord fatalT(Location loc, String subloc, String msg, Object[] args) {
        return loc.logInt(600, this.replaceArguments(msg, args));
    }

    public LogRecord fatal(Location loc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(600, msgObject.getMsgText());
    }

    public LogRecord fatal(Location loc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(600, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord fatal(Location loc, String subLoc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(600, msgObject.getMsgText());
    }

    public LogRecord fatal(Location loc, String subLoc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(600, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord logThrowableT(int severity, Location loc, String msg, Throwable exc) {
        return loc.logInt(severity, msg, exc);
    }

    public LogRecord logThrowableT(int severity, Location loc, String subloc, String msg, Throwable exc) {
        return loc.logInt(severity, msg, exc);
    }

    public LogRecord logThrowableT(int severity, Location loc, String msg, Object[] args, Throwable exc) {
        return loc.logInt(severity, this.replaceArguments(msg, args), exc);
    }

    public LogRecord logThrowableT(int severity, Location loc, String subloc, String msg, Object[] args, Throwable exc) {
        return loc.logInt(severity, this.replaceArguments(msg, args), exc);
    }

    public LogRecord logThrowable(int severity, Location loc, MsgObject msgObject, Throwable exc) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(severity, msgObject.getMsgText(), exc);
    }

    public LogRecord logThrowable(int severity, Location loc, MsgObject msgObject, Object[] args, Throwable exc) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(severity, this.replaceArguments(msgObject.getMsgText(), args), exc);
    }

    public LogRecord logThrowable(int severity, Location loc, String subLoc, MsgObject msgObject, Throwable exc) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(severity, msgObject.getMsgText(), exc);
    }

    public LogRecord logThrowable(int severity, Location loc, String subLoc, MsgObject msgObject, Object[] args, Throwable exc) {
        if (msgObject == null) {
            return null;
        }
        return loc.logInt(severity, this.replaceArguments(msgObject.getMsgText(), args), exc);
    }
}

