/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.MsgObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Location
extends LogController {
    static final String MSG_ENTERING = "Entering method";
    static final String MSG_ENTERING_WITH_PARS = "Entering method with (";
    static final String MSG_EXITING = "Exiting method";
    static final String MSG_EXITING_WITH_RES = "Exiting method with ";
    public static final String ROOT_NAME = "";
    public static final char SEPARATOR = '.';
    public static final char SPACE = ' ';
    public static final char SINGLE_QUOTE = '\'';
    private static final String NULL_STRING = "<null>";
    protected String vendor = "com.sap.";

    protected Location(String name) {
        super(name);
    }

    protected Location(String name, Location parent) {
        super(name, parent);
    }

    public static Location getRoot() {
        return Location.getLocation(ROOT_NAME);
    }

    private static String correctLocationName(String locationName) {
        boolean lastNotSeparator = true;
        if ((locationName = locationName.trim()).length() == 0) {
            return ROOT_NAME;
        }
        StringBuffer correctName = new StringBuffer(locationName.length());
        int i = 0;
        while (i < locationName.length()) {
            char currentChar = locationName.charAt(i);
            if (currentChar != '/' && currentChar > ' ' && currentChar != '\'') {
                if (currentChar == '.') {
                    if (lastNotSeparator) {
                        correctName.append(currentChar);
                    }
                    lastNotSeparator = false;
                } else {
                    correctName.append(currentChar);
                    lastNotSeparator = true;
                }
            }
            ++i;
        }
        String finalName = correctName.toString();
        int len = finalName.length();
        if (len > 1 && finalName.charAt(len - 1) == '.') {
            finalName = finalName.substring(0, len - 1);
        }
        if (len > 1 && finalName.charAt(0) == '.') {
            finalName = finalName.substring(1);
        }
        return finalName;
    }

    public static Location getLocation(String name) {
        return Location.getLocation(Location.correctLocationName(name), null);
    }

    public static Location getLocation(String name, String vendor) {
        return new Location(name);
    }

    public static Location getLocation(String name, String dcName, String csnComponent) {
        return new Location(name);
    }

    public static Location getLocation(Object instance) {
        if (instance != null) {
            return Location.getLocation(instance.getClass());
        }
        return null;
    }

    public static Location getLocation(Class<?> forClass) {
        if (forClass != null) {
            return Location.getLocation(forClass.getName());
        }
        return null;
    }

    public static Location getLocation(Location loc, String name) {
        if (loc != Location.getRoot()) {
            return Location.getLocation(String.valueOf(loc.getName()) + '.' + name.trim());
        }
        return Location.getLocation(name);
    }

    public LogRecord log(int severity, MsgObject msgObject) {
        return this.logInt(severity, msgObject.getMsgText());
    }

    public LogRecord log(int severity, String subloc, MsgObject msgObject) {
        return this.logInt(severity, msgObject.getMsgText());
    }

    public LogRecord log(int severity, MsgObject msgObject, Object[] args) {
        return this.logInt(severity, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord log(int severity, String subloc, MsgObject msgObject, Object[] args) {
        return this.logInt(severity, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord logT(int severity, String msg) {
        return this.logInt(severity, msg);
    }

    public LogRecord logT(int severity, String subloc, String msg) {
        return this.logInt(severity, msg);
    }

    public LogRecord logT(int severity, String msg, Object[] args) {
        return this.logInt(severity, this.replaceArguments(msg, args));
    }

    public LogRecord logT(int severity, String subloc, String msg, Object[] args) {
        return this.logInt(severity, this.replaceArguments(msg, args));
    }

    public LogRecord debug(MsgObject msgObject) {
        return this.logInt(100, msgObject.getMsgText());
    }

    public LogRecord debug(String subloc, MsgObject msgObject) {
        return this.logInt(100, msgObject.getMsgText());
    }

    public LogRecord debug(MsgObject msgObject, Object[] args) {
        return this.logInt(100, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord debug(String subloc, MsgObject msgObject, Object[] args) {
        return this.logInt(100, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord debugT(String msg) {
        return this.logInt(100, msg);
    }

    public LogRecord debugT(String subloc, String msg) {
        return this.logInt(100, msg);
    }

    public LogRecord debugT(String msg, Object[] args) {
        return this.logInt(100, this.replaceArguments(msg, args));
    }

    public LogRecord debugT(String subloc, String msg, Object[] args) {
        return this.logInt(100, this.replaceArguments(msg, args));
    }

    public LogRecord path(MsgObject msgObject) {
        return this.logInt(200, msgObject.getMsgText());
    }

    public LogRecord path(String subloc, MsgObject msgObject) {
        return this.logInt(200, msgObject.getMsgText());
    }

    public LogRecord path(MsgObject msgObject, Object[] args) {
        return this.logInt(200, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord path(String subloc, MsgObject msgObject, Object[] args) {
        return this.logInt(200, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord pathT(String msg) {
        return this.logInt(200, msg);
    }

    public LogRecord pathT(String subloc, String msg) {
        return this.logInt(200, msg);
    }

    public LogRecord pathT(String msg, Object[] args) {
        return this.logInt(200, this.replaceArguments(msg, args));
    }

    public LogRecord pathT(String subloc, String msg, Object[] args) {
        return this.logInt(200, this.replaceArguments(msg, args));
    }

    public LogRecord info(MsgObject msgObject) {
        return this.logInt(300, msgObject.getMsgText());
    }

    public LogRecord info(String subloc, MsgObject msgObject) {
        return this.logInt(300, msgObject.getMsgText());
    }

    public LogRecord info(MsgObject msgObject, Object[] args) {
        return this.logInt(300, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord info(String subloc, MsgObject msgObject, Object[] args) {
        return this.logInt(300, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord infoT(String msg) {
        return this.logInt(300, msg);
    }

    public LogRecord infoT(String subloc, String msg) {
        return this.logInt(300, msg);
    }

    public LogRecord infoT(String msg, Object[] args) {
        return this.logInt(300, this.replaceArguments(msg, args));
    }

    public LogRecord infoT(String subloc, String msg, Object[] args) {
        return this.logInt(300, this.replaceArguments(msg, args));
    }

    public LogRecord warning(MsgObject msgObject) {
        return this.logInt(400, msgObject.getMsgText());
    }

    public LogRecord warning(String subloc, MsgObject msgObject) {
        return this.logInt(400, msgObject.getMsgText());
    }

    public LogRecord warning(MsgObject msgObject, Object[] args) {
        return this.logInt(400, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord warning(String subloc, MsgObject msgObject, Object[] args) {
        return this.logInt(400, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord warningT(String msg) {
        return this.logInt(400, msg);
    }

    public LogRecord warningT(String subloc, String msg) {
        return this.logInt(400, msg);
    }

    public LogRecord warningT(String msg, Object[] args) {
        return this.logInt(400, this.replaceArguments(msg, args));
    }

    public LogRecord warningT(String subloc, String msg, Object[] args) {
        return this.logInt(400, this.replaceArguments(msg, args));
    }

    public LogRecord error(MsgObject msgObject) {
        return this.logInt(500, msgObject.getMsgText());
    }

    public LogRecord error(String subloc, MsgObject msgObject) {
        return this.logInt(500, msgObject.getMsgText());
    }

    public LogRecord error(MsgObject msgObject, Object[] args) {
        return this.logInt(500, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord error(String subloc, MsgObject msgObject, Object[] args) {
        return this.logInt(500, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord errorT(String msg) {
        return this.logInt(500, msg);
    }

    public LogRecord errorT(String subloc, String msg) {
        return this.logInt(500, msg);
    }

    public LogRecord errorT(String msg, Object[] args) {
        return this.logInt(500, this.replaceArguments(msg, args));
    }

    public LogRecord errorT(String subloc, String msg, Object[] args) {
        return this.logInt(500, this.replaceArguments(msg, args));
    }

    public LogRecord fatal(MsgObject msgObject) {
        return this.logInt(600, msgObject.getMsgText());
    }

    public LogRecord fatal(String subloc, MsgObject msgObject) {
        return this.logInt(600, msgObject.getMsgText());
    }

    public LogRecord fatal(MsgObject msgObject, Object[] args) {
        return this.logInt(600, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord fatal(String subloc, MsgObject msgObject, Object[] args) {
        return this.logInt(600, this.replaceArguments(msgObject.getMsgText(), args));
    }

    public LogRecord fatalT(String msg) {
        return this.logInt(600, msg);
    }

    public LogRecord fatalT(String subloc, String msg) {
        return this.logInt(600, msg);
    }

    public LogRecord fatalT(String msg, Object[] args) {
        return this.logInt(600, this.replaceArguments(msg, args));
    }

    public LogRecord fatalT(String subloc, String msg, Object[] args) {
        return this.logInt(600, this.replaceArguments(msg, args));
    }

    public LogRecord entering() {
        return this.logInt(100, MSG_ENTERING);
    }

    public LogRecord entering(String subloc) {
        return this.logInt(100, MSG_ENTERING);
    }

    private String argumentsPack(Object[] args) {
        StringBuffer argList = new StringBuffer();
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (i >= 1) {
                    argList.append(", ");
                }
                if (args[i] != null) {
                    try {
                        argList.append(args[i].toString());
                    }
                    catch (Exception exception) {
                        argList.append(NULL_STRING);
                    }
                } else {
                    argList.append(NULL_STRING);
                }
                ++i;
            }
        }
        return argList.toString();
    }

    public LogRecord entering(Object[] args) {
        String argList = this.argumentsPack(args);
        return this.logInt(200, MSG_ENTERING_WITH_PARS + argList + ")");
    }

    public LogRecord entering(String subloc, Object[] args) {
        String argList = this.argumentsPack(args);
        return this.logInt(200, MSG_ENTERING_WITH_PARS + argList);
    }

    public LogRecord exiting() {
        return this.logInt(200, MSG_EXITING);
    }

    public void exiting(String subloc) {
        this.logInt(200, MSG_EXITING);
    }

    public LogRecord exiting(Object res) {
        return this.logInt(200, MSG_EXITING_WITH_RES + res);
    }

    public void exiting(String subloc, Object res) {
        this.logInt(200, MSG_EXITING_WITH_RES + res);
    }

    public LogRecord assertion(boolean assertion, String desc) {
        return this.logInt(500, "Assertion failed: " + desc);
    }

    public LogRecord assertion(String subloc, boolean assertion, String desc) {
        return this.logInt(500, "Assertion failed: " + desc);
    }

    public LogRecord throwing(Throwable exc) {
        return this.logInt(200, "Throwing: ", exc);
    }

    public LogRecord throwing(String subloc, Throwable exc) {
        return this.logInt(200, "Throwing: ", exc);
    }

    public LogRecord catching(Throwable exc) {
        return this.logInt(200, "Caught: ", exc);
    }

    public LogRecord traceThrowable(int severity, MsgObject msgObject, Throwable exc) {
        return this.logInt(severity, msgObject.getMsgText());
    }

    public LogRecord traceThrowable(int severity, String subloc, MsgObject msgObject, Throwable exc) {
        return this.logInt(severity, msgObject.getMsgText());
    }

    public LogRecord traceThrowable(int severity, MsgObject msgObject, Object[] args, Throwable exc) {
        return this.logInt(severity, this.replaceArguments(msgObject.getMsgText(), args), exc);
    }

    public LogRecord traceThrowable(int severity, String subloc, MsgObject msgObject, Object[] args, Throwable exc) {
        return this.logInt(severity, this.replaceArguments(msgObject.getMsgText(), args), exc);
    }

    public LogRecord traceThrowableT(int severity, String msg, Throwable exc) {
        return this.logInt(severity, msg, exc);
    }

    public LogRecord traceThrowableT(int severity, String subloc, String msg, Throwable exc) {
        return this.logInt(severity, msg, exc);
    }

    public LogRecord traceThrowableT(int severity, String msg, Object[] args, Throwable exc) {
        return this.logInt(severity, this.replaceArguments(msg, args), exc);
    }

    public LogRecord traceThrowableT(int severity, String subloc, String msg, Object[] args, Throwable exc) {
        return this.logInt(severity, this.replaceArguments(msg, args), exc);
    }
}

