/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.LoggingMBeanDelegator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class LogController {
    static final String MSG_ASSERT = "Assertion failed: ";
    static final String MSG_THROWING = "Throwing: ";
    static final String MSG_CATCHING = "Caught: ";
    static final String NULL_STRING = "<null>";
    private String lcName;
    private LoggingMBeanDelegator mbeanDelegator = new LoggingMBeanDelegator();
    private Logger log4Logger = Logger.getLogger((String)"com.sap.tc.logging.Location");

    LogController(String name) {
        this.lcName = name;
        this.log4Logger = Logger.getLogger((String)name);
    }

    LogController(String name, LogController parent) {
        this.lcName = name;
        this.log4Logger = Logger.getLogger((String)name);
    }

    public int getEffectiveSeverity() {
        return this.log4Logger.getEffectiveLevel().toInt();
    }

    public synchronized String getName() {
        return this.lcName;
    }

    public synchronized void setName(String name) {
        this.lcName = name;
    }

    public boolean beDebug() {
        return this.log4Logger.isEnabledFor((Priority)Level.DEBUG);
    }

    public boolean bePath() {
        return this.log4Logger.isEnabledFor((Priority)Level.DEBUG);
    }

    public boolean beInfo() {
        return this.log4Logger.isEnabledFor((Priority)Level.INFO);
    }

    public boolean beWarning() {
        return this.log4Logger.isEnabledFor((Priority)Level.WARN);
    }

    public boolean beError() {
        return this.log4Logger.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean beFatal() {
        return this.log4Logger.isEnabledFor((Priority)Level.FATAL);
    }

    public boolean beLogged(int severity) {
        Level traceLevel = this.getLevel(severity);
        if (traceLevel != null) {
            return this.log4Logger.isEnabledFor((Priority)traceLevel);
        }
        return false;
    }

    private Level getLevel(int severity) {
        if (severity > 600) {
            this.log4Logger.error((Object)"Severity above FATAL is not allowed.");
        } else {
            if (severity > 500) {
                return Level.FATAL;
            }
            if (severity > 400) {
                return Level.ERROR;
            }
            if (severity > 300) {
                return Level.WARN;
            }
            if (severity > 200) {
                return Level.INFO;
            }
            if (severity > 99) {
                return Level.DEBUG;
            }
            if (severity < 100) {
                this.log4Logger.error((Object)"Severity below DEBUG is not allowed.");
            }
        }
        return null;
    }

    public void setEffectiveSeverity(int severity) {
        Level traceLevel = this.getLevel(severity);
        if (traceLevel != null) {
            this.mbeanDelegator.setLoggerLevel(this.log4Logger.getName(), traceLevel.toString());
        }
    }

    public void setEffectiveSeverity(int severity, boolean copyToSubtree) {
        this.setEffectiveSeverity(severity);
    }

    public void setEffectiveSeverity() {
        this.mbeanDelegator.setLoggerLevel(this.log4Logger.getName(), Level.DEBUG.toString());
    }

    public void setEffectiveSeverity(int severity, boolean copyToSubtree, int originSeverity) {
        this.setEffectiveSeverity(severity);
    }

    LogRecord logInt(int severity, String msg) {
        if (severity > 600) {
            this.log4Logger.error((Object)"Severity above FATAL is not allowed.");
        } else if (severity > 500) {
            this.log4Logger.fatal((Object)msg);
        } else if (severity > 400) {
            this.log4Logger.error((Object)msg);
        } else if (severity > 300) {
            this.log4Logger.warn((Object)msg);
        } else if (severity > 200) {
            this.log4Logger.info((Object)msg);
        } else if (severity > 99) {
            this.log4Logger.debug((Object)msg);
        } else if (severity < 100) {
            this.log4Logger.error((Object)"Severity below DEBUG is not allowed.");
        }
        return null;
    }

    LogRecord logInt(int severity, String msg, Throwable exc) {
        if (exc == null) {
            this.logInt(severity, msg);
        } else if (severity > 600) {
            this.log4Logger.error((Object)"Severity above FATAL is not allowed.");
        } else if (severity > 500) {
            this.log4Logger.fatal((Object)msg, exc);
        } else if (severity > 400) {
            this.log4Logger.error((Object)msg, exc);
        } else if (severity > 300) {
            this.log4Logger.warn((Object)msg, exc);
        } else if (severity > 200) {
            this.log4Logger.info((Object)msg, exc);
        } else if (severity > 99) {
            this.log4Logger.debug((Object)msg, exc);
        } else if (severity < 100) {
            this.log4Logger.error((Object)"Severity below DEBUG is not allowed.");
        }
        return null;
    }

    String replaceArguments(String message, Object[] args) {
        if (args == null || message == null) {
            return message;
        }
        StringBuilder messageBuilder = new StringBuilder(message);
        int ind = 0;
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            int ii = messageBuilder.indexOf("{" + ind + "}");
            if (ii >= 0) {
                messageBuilder.replace(ii, ii + 3, o == null ? "null" : o.toString());
            }
            ++ind;
            ++n2;
        }
        return messageBuilder.toString();
    }
}

