/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.auth.service;

import com.sap.core.jpaas.security.auth.api.AuthenticationService;
import com.sap.core.jpaas.security.auth.service.internal.AuthenticationConfiguration;
import com.sap.core.jpaas.security.auth.service.internal.AuthenticationStackConfiguration;
import com.sap.core.jpaas.security.auth.service.internal.AuthenticationStackConfigurationManager;
import com.sap.core.jpaas.security.auth.service.internal.LoginContext;
import com.sap.core.jpaas.security.auth.service.internal.exceptions.AuthenticationStackConfigurationException;
import com.sap.core.jpaas.security.auth.service.internal.osgi.Activator;
import com.sap.core.jpaas.security.auth.service.lib.AuthenticationStack;
import com.sap.core.jpaas.security.auth.service.lib.AuthenticationStackReference;
import com.sap.core.jpaas.security.utils.RuntimeUtils;
import com.sap.engine.lib.security.login.BaseLoginException;
import com.sap.security.auth.service.AuthenticationStackDefinition;
import com.sap.security.auth.service.ThreadAuthenticationContext;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationServiceImpl
implements AuthenticationService {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationServiceImpl.class);
    static Configuration appAuthenticationConfiguration;
    private AuthenticationStackConfigurationManager manager;

    public LoginContext createLoginContext() throws LoginException {
        return this.createLoginContext(null, null, null, null);
    }

    public LoginContext createLoginContext(String authenticationStack) throws LoginException {
        return this.createLoginContext(authenticationStack, null, null, null);
    }

    public LoginContext createLoginContext(String authenticationStack, CallbackHandler callbackHandler) throws LoginException {
        return this.createLoginContext(authenticationStack, null, callbackHandler, null);
    }

    public LoginContext createLoginContext(String authenticationStack, Subject subject) throws LoginException {
        return this.createLoginContext(authenticationStack, subject, null, null);
    }

    public LoginContext createLoginContext(String authenticationStack, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        return this.createLoginContext(authenticationStack, subject, callbackHandler, null);
    }

    public LoginContext createLoginContext(String authenticationStack, Subject subject, CallbackHandler callbackHandler, Configuration configuration) throws LoginException {
        return this.internalCreateLoginContext(authenticationStack, subject, callbackHandler, configuration);
    }

    public Configuration getConfiguration() throws LoginException {
        if (appAuthenticationConfiguration == null) {
            if (this.isCloudCase()) {
                this.manager = this.getAuthenticationStackConfigurationManager();
                try {
                    Map<String, List<AppConfigurationEntry>> appConfigurationEntries = this.manager.getAppConfigurationEntries();
                    if (appConfigurationEntries != null) {
                        appAuthenticationConfiguration = new AuthenticationConfiguration(appConfigurationEntries);
                    }
                    LOG.debug("Reading authentication configuration from file system.");
                    appAuthenticationConfiguration = Configuration.getConfiguration();
                }
                catch (AuthenticationStackConfigurationException e) {
                    throw new BaseLoginException("Unable to obtain JAAS configuration", (Throwable)e);
                }
            } else {
                try {
                    appAuthenticationConfiguration = Configuration.getConfiguration();
                }
                catch (SecurityException e) {
                    throw new BaseLoginException("Unable to obtain the installed JAAS configuration", (Throwable)e);
                }
            }
        }
        return appAuthenticationConfiguration;
    }

    void setAuthenticationStackConfigurationManager(AuthenticationStackConfigurationManager manager) {
        this.manager = manager;
    }

    private AuthenticationStackConfigurationManager getAuthenticationStackConfigurationManager() {
        if (this.manager == null) {
            this.manager = AuthenticationStackConfigurationManager.getInstance();
        }
        return this.manager;
    }

    private LoginContext internalCreateLoginContext(String name, Subject subject, CallbackHandler callbackHandler, Configuration configuration) throws LoginException {
        if (LOG.isInfoEnabled()) {
            LOG.info("Instantiation of a login context with provided: name - {}; subject - {}; callback handler - {}; configuration - {}.", new Object[]{name, subject != null, callbackHandler != null, configuration != null});
        }
        if (subject == null) {
            subject = new Subject();
        }
        if (name == null) {
            AuthenticationStack stack = ThreadAuthenticationContext.getInstance().getAuthenticationConfiguration();
            if (stack instanceof AuthenticationStackReference) {
                name = ((AuthenticationStackReference)stack).getName();
                configuration = this.getConfiguration();
            } else if (stack instanceof AuthenticationStackDefinition) {
                name = ThreadAuthenticationContext.getInstance().getRequestedResource();
                configuration = new AuthenticationStackConfiguration(((AuthenticationStackDefinition)stack).getAppConfigurationEntry());
            } else {
                throw new LoginException("No container provided authentication configuration for the request!");
            }
            callbackHandler = ThreadAuthenticationContext.getInstance().getCallbackHandler();
            return this.newLoginContext(name, stack, subject, callbackHandler, configuration);
        }
        if (configuration == null) {
            configuration = this.getConfiguration();
            if (callbackHandler == null) {
                callbackHandler = ThreadAuthenticationContext.getInstance().getCallbackHandler(name);
            }
            return this.newLoginContext(name, (AuthenticationStack)new AuthenticationStackReference(name), subject, callbackHandler, configuration);
        }
        if (callbackHandler == null) {
            callbackHandler = ThreadAuthenticationContext.getInstance().getCallbackHandler(name);
        }
        AuthenticationStackDefinition stack = new AuthenticationStackDefinition(configuration.getAppConfigurationEntry(name));
        return this.newLoginContext(name, stack, subject, callbackHandler, configuration);
    }

    private LoginContext newLoginContext(String name, AuthenticationStack authenticationStack, Subject subject, CallbackHandler callbackHandler, Configuration configuration) throws LoginException {
        ClassLoader saveLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (RuntimeUtils.isRunningInOsgi()) {
                Thread.currentThread().setContextClassLoader(Activator.getClassLoader());
            } else {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            LoginContext loginContext = new LoginContext(name, authenticationStack, subject, callbackHandler, configuration);
            if (LOG.isInfoEnabled()) {
                LOG.info("Successfully obtained login context for {}.", (Object)name);
            }
            LoginContext loginContext2 = loginContext;
            return loginContext2;
        }
        catch (Exception e) {
            String errorMessage = String.format("Cannot get login context for configuration entry with name: [%s]", name);
            if (authenticationStack instanceof AuthenticationStackDefinition) {
                errorMessage = String.format("%s from authentication login stack: [%s].", errorMessage, authenticationStack);
            }
            LOG.error(errorMessage, (Throwable)e);
            throw new BaseLoginException(errorMessage, (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(saveLoader);
        }
    }

    boolean isCloudCase() {
        return System.getenv("HC_LANDSCAPE") != null;
    }
}

