/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.auth.service;

import com.sap.core.jpaas.security.auth.service.TenantSessionCookieConfigurationAccessor;
import com.sap.core.jpaas.security.utils.Base64;
import com.sap.core.tenant.api.Tenant;
import com.sap.core.tenant.common.TenantData;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantSessionCookieConfigration {
    static final String NAME_PREFIX_KEY = "cookie_name_prefix";
    static final String NAME_PREFIX_DEFAULT = "JTENANTSESSIONID_";
    static final String LENGTH_KEY = "value_length";
    static final String LENGTH_DEFAULT = "32";
    static final String ENABLE_RELAX_LEVEL = "enable_relax_level";
    static final String ENABLE_RELAX_LEVEL_DEFAULT = "false";
    static final String RELAX_LEVEL_KEY = "relax_level";
    static final String RELAX_LEVEL_DEFAULT = "2";
    static final String DOMAINS_KEY = "cookie_domain";
    static final String DOMAINS_DEFAULT = ".neo.ondemand.com;.hana.ondemand.com;.hanatrial.ondemand.com;.us1.hanatrial.ondemand.com;.ap1.hanatrial.ondemand.com;.ondemand.com;.netweaver.ondemand.com;.hana.ondemand.com;.prod.jpaas.sapbydesign.com;.int.nw.ondemand.com;.staging.nw.ondemand.com;.nwtrial.ondemand.com;.hanatrial.ondemand.com;.qual.jpaas.sapbydesign.com;.dev007.jpaas.sapbydesign.com;.gold.jpaas.sapbydesign.com";
    static final String BIG_IP_CN_KEY = "authenticator_bigip_cn";
    static final String BIG_IP_CN_DEFAULT = "bigip";
    static final String P3P_HEADER_KEY = "p3p_header";
    static final String P3P_HEADER_DEFAULT = "CP=\"IDC DSP COR ADM DEVi TAIi PSA PSD IVAi IVDi CONi HIS OUR IND CNT\"";
    private static final Logger LOG = LoggerFactory.getLogger(TenantSessionCookieConfigration.class);
    private static final Pattern IPv4_PATTERN = Pattern.compile("\\d+\\.\\d+\\.\\d+\\.\\d+");
    private static SecureRandom secureRandom = new SecureRandom();
    private String namePrefix;
    private int length;
    private int relaxLevel;
    private boolean relaxLevelEnabled;
    private List<String> domains;
    private static TenantSessionCookieConfigration instance;
    private String bigIpCN;
    private String p3pHeader;

    public static synchronized TenantSessionCookieConfigration getInstance() {
        if (instance == null) {
            instance = new TenantSessionCookieConfigration();
            instance.updateConfiguration(TenantSessionCookieConfigurationAccessor.getConfiguration());
        }
        return instance;
    }

    synchronized void updateConfiguration(Dictionary tenantCookieProperties) {
        this.namePrefix = (String)tenantCookieProperties.get(NAME_PREFIX_KEY);
        this.length = (Integer)tenantCookieProperties.get(LENGTH_KEY);
        this.relaxLevelEnabled = (Boolean)tenantCookieProperties.get(ENABLE_RELAX_LEVEL);
        this.relaxLevel = (Integer)tenantCookieProperties.get(RELAX_LEVEL_KEY);
        this.domains = (List)tenantCookieProperties.get(DOMAINS_KEY);
        this.bigIpCN = (String)tenantCookieProperties.get(BIG_IP_CN_KEY);
        this.p3pHeader = (String)tenantCookieProperties.get(P3P_HEADER_KEY);
    }

    public String getBigIPCN() {
        return this.bigIpCN;
    }

    public String getCookieNamePrefix() {
        return this.namePrefix;
    }

    public String getCookieName() {
        String name = String.valueOf(this.namePrefix) + TenantSessionCookieConfigration.getTenantAlias();
        try {
            name = URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unable to encode name of tenant session cookie: " + name, (Throwable)e);
        }
        return name;
    }

    public String getRandomValue() {
        byte[] data = new byte[this.length];
        int i = 0;
        while (i < this.length) {
            data[i] = (byte)secureRandom.nextInt(255);
            ++i;
        }
        String result = Base64.encode((byte[])data);
        try {
            result = URLEncoder.encode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Error while URL encoding new random cookie value: " + result, (Throwable)e);
        }
        return result;
    }

    public String getDomain(String host) {
        LOG.debug("Entering getDomain(String host) with host {}", (Object)host);
        if (host != null && host.contains(".")) {
            String hostDomain = "." + host;
            for (String domain : this.domains) {
                if (!hostDomain.endsWith(domain)) continue;
                LOG.debug("getDomain() returns domain {}", (Object)domain);
                return domain;
            }
            if (IPv4_PATTERN.matcher(host).matches()) {
                LOG.debug("getDomain() returns null");
                return null;
            }
            if (!this.relaxLevelEnabled) {
                LOG.debug("getDomain() returns null(2)");
                return null;
            }
            LOG.debug("Relax level is enabled");
            String[] tokens = host.split("\\.");
            if (tokens.length - this.relaxLevel >= 2) {
                StringBuilder sb = new StringBuilder();
                int i = this.relaxLevel;
                while (i < tokens.length) {
                    sb.append(".").append(tokens[i]);
                    ++i;
                }
                String domain = sb.toString();
                LOG.debug("getDomain() returns(2) domain {}", (Object)domain);
                return domain;
            }
        }
        LOG.debug("getDomain() returns null(3)");
        return null;
    }

    public Set<String> getAllMatchingDomains(String host) {
        HashSet<String> matchingDomains = new HashSet<String>();
        if (host != null && host.contains(".")) {
            String[] tokens;
            for (String domain : this.domains) {
                String hostDomain = "." + host;
                if (!hostDomain.endsWith(domain)) continue;
                matchingDomains.add(domain);
            }
            if (!IPv4_PATTERN.matcher(host).matches() && (tokens = host.split("\\.")).length - this.relaxLevel >= 2) {
                StringBuilder sb = new StringBuilder();
                int i = this.relaxLevel;
                while (i < tokens.length) {
                    sb.append(".").append(tokens[i]);
                    ++i;
                }
                matchingDomains.add(sb.toString());
            }
        }
        return matchingDomains;
    }

    public String getP3pHeader() {
        return this.p3pHeader;
    }

    private static String getTenantAlias() {
        TenantData tenantData = Tenant.getData();
        String tenantAlias = "default";
        if (tenantData != null) {
            tenantAlias = tenantData.getAlias();
        }
        return tenantAlias;
    }
}

