/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.auth.service;

import com.sap.core.jpaas.security.auth.service.TenantSessionCookieConfigration;
import com.sap.core.jpaas.security.utils.RuntimeUtils;
import com.sap.security.auth.util.AuthConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantSessionCookieConfigurationAccessor {
    private static final Logger logger = LoggerFactory.getLogger(TenantSessionCookieConfigurationAccessor.class);
    private static final String TENANT_SESSION_COOKIE_FILE_PATH = String.valueOf(AuthConstants.CONFIG_DIR) + File.separator + "tenant_session_cookie.properties";
    static Properties configuration = new Properties();

    static synchronized void updateProperties(Dictionary tenantCookieProperties) {
        if (tenantCookieProperties != null) {
            TenantSessionCookieConfigurationAccessor.setConfigurationValues(tenantCookieProperties);
        } else {
            TenantSessionCookieConfigurationAccessor.setDefaultValues();
        }
        logger.debug("Updating tenant session cookie configuration with values: {}", (Object)configuration);
        TenantSessionCookieConfigration.getInstance().updateConfiguration(configuration);
    }

    public static Properties getConfiguration() {
        if (!RuntimeUtils.isRunningInOsgi() && configuration.isEmpty()) {
            logger.debug("Get tenant session cookie configuration from local configuration service");
            Properties properties = TenantSessionCookieConfigurationAccessor.readTenantSessionCookiePropertiesFromFileSystem();
            if (properties != null) {
                TenantSessionCookieConfigurationAccessor.setConfigurationValues(properties);
            }
        }
        if (configuration.isEmpty()) {
            TenantSessionCookieConfigurationAccessor.setDefaultValues();
        }
        logger.debug("Tenant session cookie configuration: {}", (Object)configuration);
        return configuration;
    }

    private static void setConfigurationValues(Dictionary tenantCookieProperties) {
        String namePrefix = TenantSessionCookieConfigurationAccessor.getProperty(tenantCookieProperties, "cookie_name_prefix", "JTENANTSESSIONID_");
        int length = Integer.parseInt(TenantSessionCookieConfigurationAccessor.getProperty(tenantCookieProperties, "value_length", "32"));
        boolean relaxLevelEnabled = Boolean.parseBoolean(TenantSessionCookieConfigurationAccessor.getProperty(tenantCookieProperties, "enable_relax_level", "false"));
        int relaxLevel = Integer.parseInt(TenantSessionCookieConfigurationAccessor.getProperty(tenantCookieProperties, "relax_level", "2"));
        List<String> domains = TenantSessionCookieConfigurationAccessor.getPropertyAsList(tenantCookieProperties, "cookie_domain", ".neo.ondemand.com;.hana.ondemand.com;.hanatrial.ondemand.com;.us1.hanatrial.ondemand.com;.ap1.hanatrial.ondemand.com;.ondemand.com;.netweaver.ondemand.com;.hana.ondemand.com;.prod.jpaas.sapbydesign.com;.int.nw.ondemand.com;.staging.nw.ondemand.com;.nwtrial.ondemand.com;.hanatrial.ondemand.com;.qual.jpaas.sapbydesign.com;.dev007.jpaas.sapbydesign.com;.gold.jpaas.sapbydesign.com");
        String bigIpCN = TenantSessionCookieConfigurationAccessor.getProperty(tenantCookieProperties, "authenticator_bigip_cn", "bigip");
        String p3pHeader = TenantSessionCookieConfigurationAccessor.getProperty(tenantCookieProperties, "p3p_header", "CP=\"IDC DSP COR ADM DEVi TAIi PSA PSD IVAi IVDi CONi HIS OUR IND CNT\"");
        configuration.put("cookie_name_prefix", namePrefix);
        configuration.put("value_length", (Object)length);
        configuration.put("enable_relax_level", (Object)relaxLevelEnabled);
        configuration.put("relax_level", (Object)relaxLevel);
        configuration.put("cookie_domain", domains);
        configuration.put("authenticator_bigip_cn", bigIpCN);
        configuration.put("p3p_header", p3pHeader);
    }

    private static Properties readTenantSessionCookiePropertiesFromFileSystem() {
        File tenantSessionCookieFile = new File(TENANT_SESSION_COOKIE_FILE_PATH);
        if (!tenantSessionCookieFile.exists()) {
            logger.debug("File {} does not exist.", (Object)TENANT_SESSION_COOKIE_FILE_PATH);
            return null;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(tenantSessionCookieFile);
            Properties properties = new Properties();
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            logger.warn("Cannot access configuration tenant_session_cookie.properties; default values will be used", (Throwable)e);
            return null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.warn("Failed to close stream.", (Throwable)e);
                }
            }
        }
    }

    private static synchronized void setDefaultValues() {
        logger.warn("Property file for reading tenant session cookies configuration can not be found. The default values will be used in this case.");
        String namePrefix = "JTENANTSESSIONID_";
        int length = Integer.parseInt("32");
        boolean enabledRelaxLevel = Boolean.parseBoolean("false");
        int relaxLevel = Integer.parseInt("2");
        List<String> domains = TenantSessionCookieConfigurationAccessor.getPropertyAsList(".neo.ondemand.com;.hana.ondemand.com;.hanatrial.ondemand.com;.us1.hanatrial.ondemand.com;.ap1.hanatrial.ondemand.com;.ondemand.com;.netweaver.ondemand.com;.hana.ondemand.com;.prod.jpaas.sapbydesign.com;.int.nw.ondemand.com;.staging.nw.ondemand.com;.nwtrial.ondemand.com;.hanatrial.ondemand.com;.qual.jpaas.sapbydesign.com;.dev007.jpaas.sapbydesign.com;.gold.jpaas.sapbydesign.com");
        String bigIpCN = "bigip";
        String p3pHeader = "CP=\"IDC DSP COR ADM DEVi TAIi PSA PSD IVAi IVDi CONi HIS OUR IND CNT\"";
        configuration.put("cookie_name_prefix", namePrefix);
        configuration.put("value_length", (Object)length);
        configuration.put("enable_relax_level", (Object)enabledRelaxLevel);
        configuration.put("relax_level", (Object)relaxLevel);
        configuration.put("cookie_domain", domains);
        configuration.put("authenticator_bigip_cn", bigIpCN);
        configuration.put("p3p_header", p3pHeader);
    }

    private static String getProperty(Dictionary properties, String key, String defaultValue) {
        String value = (String)properties.get(key);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        return value.trim();
    }

    private static List<String> getPropertyAsList(Dictionary properties, String key, String defaultValue) {
        String valueList = TenantSessionCookieConfigurationAccessor.getProperty(properties, key, defaultValue).trim();
        return TenantSessionCookieConfigurationAccessor.getPropertyAsList(valueList);
    }

    private static List<String> getPropertyAsList(String valueList) {
        if ((valueList = valueList.trim()).length() > 0) {
            return Arrays.asList(valueList.split(";"));
        }
        return new ArrayList<String>();
    }
}

