/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.auth.service.internal;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.sap.core.jpaas.security.auth.service.internal.ConfigurationData;
import com.sap.core.jpaas.security.auth.service.internal.data.AuthnCfg;
import com.sap.core.jpaas.security.auth.service.internal.data.AuthnMethod;
import com.sap.core.jpaas.security.auth.service.internal.data.LoginModuleData;
import com.sap.core.jpaas.security.auth.service.internal.data.LoginModuleMapping;
import com.sap.core.jpaas.security.auth.service.internal.data.LoginModuleMappingEntry;
import com.sap.core.jpaas.security.auth.service.internal.exceptions.AuthenticationStackConfigurationException;
import com.sap.core.jpaas.security.utils.FileUtils;
import com.sap.core.jpaas.security.utils.connection.Connection;
import com.sap.core.jpaas.security.utils.connection.Request;
import com.sap.core.jpaas.security.utils.connection.Response;
import com.sap.core.jpaas.security.utils.connection.impl.DomainDBConnection;
import com.sap.core.jpaas.security.utils.connection.impl.URLRequest;
import com.sap.security.auth.util.AuthConstants;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationStackConfigurationManager {
    private static final String AUTHN_CONFIGURATION_PATH_TEMPLATE = "rest/configuration/account/%s/application/%s/authentication/authn_cfg.json";
    private static final String ACCOUNT_PROPERTY_KEY = "HC_ACCOUNT";
    private static final String APPLIANCE_PROPERTY_KEY = "HC_APPLICATION";
    private Properties sapceProps;
    private Set<LoginModuleMapping> loginModuleMappings = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationStackConfigurationManager.class);
    private static final AuthenticationStackConfigurationManager instance = new AuthenticationStackConfigurationManager();

    public static AuthenticationStackConfigurationManager getInstance() {
        return instance;
    }

    AuthenticationStackConfigurationManager() {
        try {
            this.loginModuleMappings = this.getLoginModulesMappings();
        }
        catch (AuthenticationStackConfigurationException e) {
            throw new IllegalStateException("Cannot initailize LoginModulesMappings from the file system", e);
        }
        this.sapceProps = this.getSpaceProperties();
    }

    public Map<String, List<AppConfigurationEntry>> getAppConfigurationEntries() throws AuthenticationStackConfigurationException {
        AuthnCfg authnCfg = this.getAuthnConfiguration();
        if (authnCfg == null || !authnCfg.isEnabled()) {
            return null;
        }
        List<AuthnMethod> authnMethods = authnCfg.getAuthnMethods();
        Map<String, List<AppConfigurationEntry>> configuration = this.generateAppConfigurationMap(authnMethods);
        return configuration;
    }

    Properties getSpaceProperties() {
        Properties result = new Properties();
        result.putAll(System.getenv());
        return result;
    }

    String getCfgFileName() {
        return String.valueOf(AuthConstants.CONFIG_DIR) + File.separator + "login_modules_mappings.json";
    }

    AuthnCfg getAuthnConfiguration() throws AuthenticationStackConfigurationException {
        String authnCfgResponseContent = null;
        AuthnCfg authnCfg = null;
        String account = this.sapceProps.getProperty(ACCOUNT_PROPERTY_KEY);
        String application = this.sapceProps.getProperty(APPLIANCE_PROPERTY_KEY);
        try {
            LOGGER.debug("Trying to read authentication configuration from Domain DB for account: [{}] and application: [{}]", (Object)account, (Object)application);
            authnCfgResponseContent = this.fetchConfiguration(account, application);
            LOGGER.debug("Raw content of the configuration is: [{}]", (Object)authnCfgResponseContent);
            authnCfg = this.parseAuthnConfigContentToJsonElement(authnCfgResponseContent);
        }
        catch (JsonSyntaxException exc) {
            String errorMessage = "The the login configuration JSON file saved in the domain db is malformed.";
            this.logAndWrapError(authnCfgResponseContent, (Exception)((Object)exc), errorMessage);
        }
        catch (IOException exc) {
            String errorMessage = "Cannot read the login configuration JSON file saved in the domain db.";
            this.logAndWrapError(authnCfgResponseContent, (Exception)exc, errorMessage);
        }
        LOGGER.debug("Parsed content of the configuration is : [{}]", authnCfg);
        return authnCfg;
    }

    private String fetchConfiguration(String account, String application) throws IOException {
        Request<HttpURLConnection> request;
        Connection<HttpURLConnection> connection = this.createConnection();
        Response response = connection.execute(request = this.createRequest(this.constructPath(account, application)));
        if (response.is(404)) {
            LOGGER.debug("Authentication configuration was not found in Domain DB. Null will be returned");
            return null;
        }
        if (response.isNotOK()) {
            LOGGER.error("Failed to fetch authentication configuration from Domain DB. Response code: {}. Response body: [{}]", (Object)response.getStatus(), (Object)response.asString());
            throw new IOException("Failed to fetch authentication configuration from Domain DB");
        }
        return ConfigurationData.extractContentFromConfigData(response.asString());
    }

    Connection<HttpURLConnection> createConnection() {
        return new DomainDBConnection();
    }

    private Request<HttpURLConnection> createRequest(String path) {
        return (Request)new URLRequest.Builder().withGETMethod().withPath(path).build();
    }

    private String constructPath(String account, String application) {
        return String.format(AUTHN_CONFIGURATION_PATH_TEMPLATE, account, application);
    }

    Set<LoginModuleMapping> getLoginModulesMappings() throws AuthenticationStackConfigurationException {
        HashSet<LoginModuleMapping> loginModuleMappings = new HashSet();
        String cfgFileName = this.getCfgFileName();
        File loginModuleMappingsFile = new File(cfgFileName);
        String loginModuleMappingsContent = FileUtils.readFile((File)loginModuleMappingsFile);
        try {
            loginModuleMappings = this.parseLoginModuleMappingContentToJsonElement(loginModuleMappingsContent);
        }
        catch (JsonSyntaxException exc) {
            String errorMessage = "The JSON file login_modules_mappings.json is malformed.";
            this.logAndWrapError(loginModuleMappings, (Exception)((Object)exc), errorMessage);
        }
        catch (InvalidParameterException exc) {
            String errorMessage = "The JSON file login_modules_mappings.json is empty or missing.";
            this.logAndWrapError(loginModuleMappings, (Exception)exc, errorMessage);
        }
        return loginModuleMappings;
    }

    private Map<String, List<AppConfigurationEntry>> generateAppConfigurationMap(List<AuthnMethod> authnMethods) throws AuthenticationStackConfigurationException {
        HashMap<String, List<AppConfigurationEntry>> configuration = new HashMap<String, List<AppConfigurationEntry>>();
        if (authnMethods == null || authnMethods.size() == 0) {
            return configuration;
        }
        for (AuthnMethod authnMethod : authnMethods) {
            String loginModuleName = authnMethod.getName();
            if (loginModuleName == null) continue;
            List<LoginModuleData> loginModuleDatas = authnMethod.getActiveLoginModules();
            List<AppConfigurationEntry> configurationEntries = this.transformToConfigurationEntryList(loginModuleDatas);
            configuration.put(loginModuleName, configurationEntries);
        }
        return configuration;
    }

    private List<AppConfigurationEntry> transformToConfigurationEntryList(List<LoginModuleData> loginModuleDatas) throws AuthenticationStackConfigurationException {
        ArrayList<AppConfigurationEntry> configurationEntries = new ArrayList<AppConfigurationEntry>();
        if (loginModuleDatas == null || loginModuleDatas.isEmpty()) {
            return configurationEntries;
        }
        for (LoginModuleData loginModuleData : loginModuleDatas) {
            LoginModuleMappingEntry loginModuleMappingEntry;
            String id = loginModuleData.getId();
            if (id == null || (loginModuleMappingEntry = this.getLoginModuleMappingEntry(id)) == null) continue;
            String className = loginModuleMappingEntry.getClassName();
            Map<String, String> options = loginModuleMappingEntry.getOptions();
            AppConfigurationEntry appConfigurationEntry = new AppConfigurationEntry(className, AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, options);
            configurationEntries.add(appConfigurationEntry);
        }
        return configurationEntries;
    }

    private LoginModuleMappingEntry getLoginModuleMappingEntry(String id) throws AuthenticationStackConfigurationException {
        if (this.loginModuleMappings == null || this.loginModuleMappings.isEmpty()) {
            throw new AuthenticationStackConfigurationException("No Login mappings configured. Authentication is impossible.");
        }
        for (LoginModuleMapping loginModuleMapping : this.loginModuleMappings) {
            if (!id.equals(loginModuleMapping.getId())) continue;
            LoginModuleMappingEntry module = loginModuleMapping.getModule();
            if (module.getClassName() == null || module.getOptions() == null) {
                throw new AuthenticationStackConfigurationException("Illegal mapping configuration for stack [" + id + "]. Authentication is impossible.");
            }
            return module;
        }
        return null;
    }

    private AuthnCfg parseAuthnConfigContentToJsonElement(String authnCfgResponseContent) throws JsonSyntaxException {
        if (authnCfgResponseContent == null) {
            return null;
        }
        AuthnCfg cfg = (AuthnCfg)new Gson().fromJson(authnCfgResponseContent, AuthnCfg.class);
        if (cfg == null) {
            throw new JsonSyntaxException("Authn configuraiton saved in domain db is malformed.");
        }
        return cfg;
    }

    private Set<LoginModuleMapping> parseLoginModuleMappingContentToJsonElement(String authnCfgResponseContent) throws JsonSyntaxException {
        if (authnCfgResponseContent == null || "".equals(authnCfgResponseContent)) {
            throw new InvalidParameterException("Login module mapping configuraiton is empty.");
        }
        Set loginModuleMappings = new HashSet();
        loginModuleMappings = (Set)new Gson().fromJson(authnCfgResponseContent, new TypeToken<Set<LoginModuleMapping>>(){}.getType());
        if (loginModuleMappings == null) {
            throw new JsonSyntaxException("Login module mapping configuraiton is malformed.");
        }
        return loginModuleMappings;
    }

    private void logAndWrapError(String authnCfgResponseContent, Exception exc, String errorMessage) throws AuthenticationStackConfigurationException {
        LOGGER.error(errorMessage, (Throwable)exc);
        AuthenticationStackConfigurationException authnStackConfigurationExc = new AuthenticationStackConfigurationException(errorMessage, exc);
        authnStackConfigurationExc.setConfigurationContent(authnCfgResponseContent);
        throw authnStackConfigurationExc;
    }

    private void logAndWrapError(Set<LoginModuleMapping> authnCfgResponseContent, Exception exc, String errorMessage) throws AuthenticationStackConfigurationException {
        LOGGER.error(errorMessage, (Throwable)exc);
        AuthenticationStackConfigurationException authnStackConfigurationExc = new AuthenticationStackConfigurationException(errorMessage, exc);
        HashSet<String> authnCfgContetnAsString = new HashSet<String>();
        if (authnCfgResponseContent != null) {
            for (LoginModuleMapping loginModuleMapping : authnCfgResponseContent) {
                authnCfgContetnAsString.add(loginModuleMapping.toString());
            }
            authnStackConfigurationExc.setConfigurationContent(Arrays.toString(authnCfgContetnAsString.toArray(new String[0])));
        }
        throw authnStackConfigurationExc;
    }
}

