/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.auth.service.internal;

import com.sap.core.jpaas.security.auth.lib.callback.AuthnStateCallback;
import com.sap.core.jpaas.security.auth.service.TenantSessionCookieConfigration;
import com.sap.core.jpaas.security.auth.service.internal.osgi.Activator;
import com.sap.core.jpaas.security.auth.service.lib.AuthenticationStack;
import com.sap.core.jpaas.security.utils.AuditLogUtil;
import com.sap.core.jpaas.security.utils.RuntimeUtils;
import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.engine.lib.security.login.BaseLoginException;
import com.sap.engine.lib.security.login.SubjectWrapper;
import com.sap.engine.lib.security.login.UnsupportedPrincipalChangeException;
import com.sap.security.auth.service.ThreadAuthenticationContext;
import com.sap.security.auth.service.UserSession;
import com.sap.security.auth.util.Utils;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.User;
import com.sap.security.um.user.UserProvider;
import java.util.Calendar;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginContext
extends javax.security.auth.login.LoginContext {
    private static final Logger LOG = LoggerFactory.getLogger(LoginContext.class);
    private static final String LOGIN_OK = "LOGIN.OK";
    private static final String LOGIN_FAILED = "LOGIN.FAILED";
    private static final String LOGIN_FAILED_SECOND_FACTOR_EXPECTED = "LOGIN.FAILED.SECOND.FACTOR.EXPECTED";
    private static final String LOGIN_FAILED_PASS_DIABLED = "LOGIN.FAILED.PASSWORD.DISABLED";
    private static final String LOGIN_FAILED_PASS_LOCKED = "LOGIN.FAILED.PASSWORD.LOCKED";
    private static final String LOGIN_FAILED_USER_INACTIVE = "LOGIN.FAILED.USER.INACTIVE";
    private static final String LOGIN_FAILED_PASS_WRONG = "LOGIN.FAILED.PASSWORD.WRONG";
    private static final String LOGOUT_OK = "LOGOUT.OK";
    private static final String LOGOUT_FAILED = "LOGOUT.FAILED";
    private static final String AUTIDLOG_SUCCESSFUL_AUTHENTICATION_ENABLED = "autidlog.successful.authentication.enabled";
    protected CallbackHandler callbackHandler = null;
    private String name = null;
    private AuthenticationStack authenticationStack = null;
    private String userName = null;
    private Configuration configuration;

    public LoginContext(String name, AuthenticationStack authenticationStack, Subject subject, CallbackHandler callbackHandler, Configuration config) throws LoginException {
        super(name, subject, callbackHandler, config);
        this.name = name;
        this.authenticationStack = authenticationStack;
        this.callbackHandler = callbackHandler;
        this.configuration = config;
    }

    @Override
    public void login() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entering LoginContext.login() method. \nStack: " + this.name + "\nAuthentication stack: " + this.authenticationStack);
        }
        this.userName = null;
        SubjectWrapper subjectWrapper = null;
        ClassLoader saveLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                if (RuntimeUtils.isRunningInOsgi()) {
                    Thread.currentThread().setContextClassLoader(Activator.getClassLoader());
                } else {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("LOADER: " + Thread.currentThread().getContextClassLoader());
                }
                LOG.debug("Entering javax.security.auth.login.LoginContext.login() method");
                super.login();
                subjectWrapper = new SubjectWrapper(this.getSubject());
                if (LOG.isInfoEnabled()) {
                    LOG.info("Created new " + subjectWrapper + " from login subject and principal ");
                }
                this.userName = subjectWrapper.getPrincipal().getName();
                this.centralChecks(this.userName);
                ThreadAuthenticationContext.getInstance().setAuthenticatedPrincipal(this.userName);
                this.notifyAuthnState(AuthnStateCallback.LOGIN_OK);
                UserSession.getInstance().setSubject(subjectWrapper);
                LOG.info("Authentication for user {} is successful. ", (Object)this.userName);
                if (Boolean.getBoolean(AUTIDLOG_SUCCESSFUL_AUTHENTICATION_ENABLED)) {
                    this.auditLogSuccessfulAuthenitcation();
                }
            }
            catch (BaseLoginException exception) {
                switch (exception.getExceptionCause()) {
                    case 0: {
                        LoginContext.logInfo(LOGIN_FAILED_PASS_WRONG, this.userName, this.name, this.configuration, exception);
                        this.notifyAuthnState(AuthnStateCallback.LOGIN_FAILED);
                        break;
                    }
                    case 21: {
                        LoginContext.logInfo(LOGIN_FAILED_PASS_LOCKED, this.userName, this.name, this.configuration, exception);
                        this.notifyAuthnState(AuthnStateCallback.LOGIN_FAILED_PASSWORD_LOCKED);
                        break;
                    }
                    case 50: {
                        LoginContext.logInfo(LOGIN_FAILED_PASS_DIABLED, this.userName, this.name, this.configuration, exception);
                        this.notifyAuthnState(AuthnStateCallback.LOGIN_FAILED_PASSWORD_DISABLED);
                        break;
                    }
                    case 51: {
                        LoginContext.logInfo(LOGIN_FAILED_USER_INACTIVE, this.userName, this.name, this.configuration, exception);
                        this.notifyAuthnState(AuthnStateCallback.LOGIN_FAILED_USER_INACTIVE);
                        break;
                    }
                    case 52: {
                        LoginContext.logInfo(LOGIN_FAILED, this.userName, this.name, this.configuration, exception);
                        this.notifyAuthnState(AuthnStateCallback.LOGIN_FAILED_UNKNOWN_REASON);
                        break;
                    }
                    case 53: {
                        LoginContext.logInfo(LOGIN_FAILED_SECOND_FACTOR_EXPECTED, this.userName, this.name, this.configuration, exception);
                        this.notifyAuthnState(AuthnStateCallback.SECOND_FACTOR_EXPECTED);
                        break;
                    }
                }
                throw exception;
            }
            catch (LoginException exception) {
                LoginContext.logInfo(LOGIN_FAILED, this.userName, this.name, this.configuration, exception);
                this.notifyAuthnState(AuthnStateCallback.LOGIN_FAILED);
                throw exception;
            }
            catch (Exception exception) {
                LoginContext.logInfo(LOGIN_FAILED, this.userName, this.name, this.configuration, exception);
                this.notifyAuthnState(AuthnStateCallback.LOGIN_FAILED);
                LoginException loginException = new LoginException("Access Denied.");
                loginException.initCause(exception);
                throw loginException;
            }
            catch (Error e) {
                LoginContext.logError(LOGIN_FAILED, this.userName, this.name, this.configuration, e);
                throw e;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(saveLoader);
        }
        LoginContext.logInfo(LOGIN_OK, this.userName, this.name, this.configuration);
    }

    private void auditLogSuccessfulAuthenitcation() {
        StringBuilder loginInfo = new StringBuilder();
        loginInfo.append(String.format("Authentication for user %s is successful. \n", this.userName));
        loginInfo.append("Principals were: ");
        Subject subject = this.getSubject();
        loginInfo.append(subject.getPrincipals());
        AuditLogUtil.auditLogMessage((String)loginInfo.toString(), (String[])new String[0], this.getClass());
    }

    private void notifyAuthnState(AuthnStateCallback callback) {
        block3: {
            try {
                if (this.callbackHandler != null) {
                    this.callbackHandler.handle(new Callback[]{callback});
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception thrown for AuthnStateCallback. " + callback, (Throwable)e);
            }
        }
    }

    private void centralChecks(String userName) throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CALL CENTRAL CHECKS");
        }
        this.checkReAuthentication(userName);
        this.checkPasswordChange(userName);
    }

    private void checkUserAccount(String userName) throws LoginException {
        User user = null;
        try {
            UserProvider userManagement = UserManagementAccessor.getUserProvider();
            user = userManagement.getUser(userName);
        }
        catch (PersistenceException e) {
            throw new BaseLoginException("User account " + userName + " is not accessible", (Throwable)e, 49);
        }
        if (user == null) {
            throw new LoginException("User account " + userName + " does not exists in the userstore.");
        }
        if (!user.isValid(Calendar.getInstance())) {
            throw new LoginException("User account " + userName + " is either expired, or not valid yet.");
        }
    }

    private void checkReAuthentication(String userName) throws LoginException {
        String currentUser;
        SubjectWrapper subject = (SubjectWrapper)UserSession.getInstance().getSubject();
        if (Utils.isImpersonationScenario(this.callbackHandler)) {
            LOG.info("User impersonation scenario in progress. Skipping re-authentication check");
            return;
        }
        if (subject != null) {
            currentUser = subject.getPrincipal().getName();
            if (currentUser.equalsIgnoreCase(userName)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("User " + userName + " attempt to re-authenticate. ");
                }
            } else {
                if (LOG.isInfoEnabled()) {
                    LOG.info("User is already logged in with user name " + currentUser + " but attempt to re-authenticate with user name " + userName);
                }
                throw new LoginException("Reauthentication failed! User is already authenticated with another user account.");
            }
        }
        if ((currentUser = ThreadAuthenticationContext.getInstance().getAuthenticatedPrincipal()) != null && !currentUser.equals(userName)) {
            LOG.info("Reauthentication failed: user " + userName + " is already authenticated as " + currentUser);
            throw new UnsupportedPrincipalChangeException("Reauthentication failed. User is already authenticated with another account.");
        }
    }

    private void checkPasswordChange(String userName) throws LoginException {
    }

    @Override
    public void logout() throws LoginException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Entering LoginContext.logout() method. \nStack: " + this.name + "\nAuthentication stack: " + this.authenticationStack);
            }
            this.removeTenantCookie();
            LOG.debug("Entering javax.security.auth.login.LoginContext.logout() method");
            super.logout();
            this.notifyAuthnState(AuthnStateCallback.LOGOUT_OK);
            UserSession.getInstance().setSubject(null);
            UserSession.getInstance().logoutCurrentSession();
            LoginContext.logInfo(LOGOUT_OK, this.userName, this.name, this.configuration);
        }
        catch (LoginException e) {
            this.notifyAuthnState(AuthnStateCallback.LOGOUT_FAILED);
            LoginContext.logInfo(LOGOUT_FAILED, this.userName, this.name, this.configuration, e);
            throw e;
        }
        catch (RuntimeException e) {
            LoginContext.logError(LOGOUT_FAILED, this.userName, this.name, this.configuration, e);
            throw e;
        }
    }

    private static final void logInfo(String event, String userName, String configName, Configuration configuration) {
        if (LOG.isDebugEnabled()) {
            StringBuilder loginInfo = LoginContext.loginInfoMessage(event, userName, configName, configuration);
            LOG.debug(loginInfo.toString());
        }
    }

    private static StringBuilder loginInfoMessage(String event, String userName, String configName, Configuration configuration) {
        StringBuilder loginInfo = new StringBuilder();
        if (event != null) {
            loginInfo.append(event).append("\n");
        }
        if (userName != null) {
            loginInfo.append("User: ").append(userName).append("\n");
        }
        if (configName != null) {
            loginInfo.append("Authentication Stack: ").append(configName).append("\n");
        }
        if (configuration != null) {
            loginInfo.append("Login Modules: \n");
            AppConfigurationEntry[] appConfigEntries = configuration.getAppConfigurationEntry(configName);
            if (appConfigEntries != null) {
                AppConfigurationEntry[] appConfigurationEntryArray = appConfigEntries;
                int n = appConfigEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    AppConfigurationEntry appConfigEntry = appConfigurationEntryArray[n2];
                    loginInfo.append(appConfigEntry.getLoginModuleName());
                    loginInfo.append(" ").append(LoginContext.controlFlagToString(appConfigEntry.getControlFlag()));
                    Map<String, ?> options = appConfigEntry.getOptions();
                    for (String key : options.keySet()) {
                        loginInfo.append(" ").append(key).append("=");
                        loginInfo.append(options.get(key));
                    }
                    loginInfo.append("\n");
                    ++n2;
                }
            }
        }
        return loginInfo;
    }

    private static final void logInfo(String event, String userName, String configName, Configuration configuration, Throwable exception) {
        LoginContext.logInfo(event, userName, configName, configuration);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Caught exception: ", exception);
        }
    }

    private static final void logError(String event, String userName, String configName, Configuration configuration, Throwable exception) {
        LoginContext.logInfo(event, userName, configName, configuration);
        if (LOG.isErrorEnabled()) {
            LOG.error("Caught exception:", exception);
        }
    }

    private static String controlFlagToString(AppConfigurationEntry.LoginModuleControlFlag controlFlag) {
        if (controlFlag == AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL) {
            return "OPTIONAL";
        }
        if (controlFlag == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
            return "REQUIRED";
        }
        if (controlFlag == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
            return "REQUISITE";
        }
        if (controlFlag == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
            return "SUFFICIENT";
        }
        return "UNKNOWN";
    }

    private void removeTenantCookie() {
        try {
            TenantSessionCookieConfigration tenantSessionCookieConfigration = TenantSessionCookieConfigration.getInstance();
            String tenantSessionCookieName = tenantSessionCookieConfigration.getCookieName();
            LOG.debug("Removing tenant cookie with name: " + tenantSessionCookieName);
            HttpGetterCallback isSecureCb = new HttpGetterCallback();
            isSecureCb.setType((byte)7);
            this.callbackHandler.handle(new Callback[]{isSecureCb});
            boolean isSecure = (Boolean)isSecureCb.getValue();
            String host = UserSession.getInstance().getRequestServerName();
            String domain = tenantSessionCookieConfigration.getDomain(host);
            HttpSetterCallback setCookieCb = new HttpSetterCallback();
            setCookieCb.setType((byte)2);
            setCookieCb.setName(tenantSessionCookieName);
            String value = "0; Max-Age=0; Expires=Thu, 01-Jan-1970 00:00:10 GMT; path=/; HttpOnly;";
            if (isSecure) {
                value = String.valueOf(value) + " Secure;";
            }
            if (domain != null) {
                value = String.valueOf(value) + "domain=" + domain;
            }
            setCookieCb.setValue((Object)value);
            this.callbackHandler.handle(new Callback[]{setCookieCb});
        }
        catch (Exception e) {
            LOG.error("Problem while removing tenant session cookie. Problems may occur with SingleLogout later on.", (Throwable)e);
        }
    }
}

