/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.auth.service.internal.osgi;

import com.sap.core.jpaas.security.auth.service.internal.osgi.EnchancedClassLoader;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.Configuration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private static final String PROP_CONFIGURATION_AREA = "osgi.configuration.area";
    private static final String GLOBAL_CONFIGURATION_FOLDER = System.getProperty("sys.global.dir");
    private static final String AUTH_CONFIGURATION_FOLDER_NAME = "com.sap.security.auth.service";
    private static BundleContext bundles;
    private static ClassLoader enhancedClassLoader;
    private static Map<String, URL> factories;

    public void start(BundleContext context) throws InvalidSyntaxException {
        LOG.info("Starting authentication service ...");
        bundles = context;
        enhancedClassLoader = new EnchancedClassLoader();
        this.registerJAASConfiguration();
        factories = new HashMap<String, URL>();
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getState() == 4 || bundle.getState() == 8 || bundle.getState() == 32 || bundle.getState() == 16) {
                this.registerURL(bundle);
            }
            ++n2;
        }
        LOG.info("Started authentication service.");
    }

    public void stop() {
        LOG.info("Stopping authentication service ...");
        enhancedClassLoader = null;
        bundles = null;
        factories = null;
        LOG.info("Stopped authentication service.");
    }

    public static ClassLoader getClassLoader() {
        return enhancedClassLoader;
    }

    protected static Bundle[] getBundles() {
        return bundles.getBundles();
    }

    private final void registerJAASConfiguration() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            String configFolderName;
            Thread.currentThread().setContextClassLoader(Activator.getClassLoader());
            String authConfigurationFolder = this.initializeConfigurationFolder();
            File configFolder = null;
            if (GLOBAL_CONFIGURATION_FOLDER != null && GLOBAL_CONFIGURATION_FOLDER.trim().length() > 0) {
                configFolder = new File(GLOBAL_CONFIGURATION_FOLDER);
                configFolderName = GLOBAL_CONFIGURATION_FOLDER;
            } else if (authConfigurationFolder != null && authConfigurationFolder.trim().length() > 0) {
                configFolder = new File(authConfigurationFolder);
                configFolderName = authConfigurationFolder;
            } else {
                throw new RuntimeException("No configuration folder available");
            }
            if (!configFolder.exists() || !configFolder.isDirectory()) {
                throw new RuntimeException("Folder does not exists: " + configFolderName);
            }
            System.setProperty("java.security.auth.login.config", String.valueOf(configFolderName) + File.separator + "java.login.config");
            Configuration.getConfiguration().getAppConfigurationEntry("BASIC");
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    protected String initializeConfigurationFolder() {
        String configurationArea = System.getProperty(PROP_CONFIGURATION_AREA);
        if (configurationArea == null) {
            return null;
        }
        if ((configurationArea = configurationArea.endsWith("\\") || configurationArea.endsWith("/") ? String.valueOf(configurationArea) + AUTH_CONFIGURATION_FOLDER_NAME : String.valueOf(configurationArea) + File.separator + AUTH_CONFIGURATION_FOLDER_NAME).startsWith("file:")) {
            configurationArea = configurationArea.substring(5);
        }
        return configurationArea;
    }

    protected void registerURL(Bundle bundle) {
        Enumeration e = bundle.findEntries("META-INF/services/", "*", false);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL url = (URL)e.nextElement();
                if (url.toString().endsWith("/")) continue;
                String factoryId = url.toString().substring(url.toString().lastIndexOf("/") + 1);
                factories.put(factoryId, url);
            }
        }
    }

    protected static synchronized URL locate(String factoryId) {
        if (factoryId != null) {
            String key = factoryId.substring(factoryId.lastIndexOf("/") + 1);
            return factories.get(key);
        }
        return null;
    }
}

