/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.auth.service.internal.osgi;

import com.sap.core.jpaas.security.auth.service.internal.osgi.Activator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.osgi.framework.Bundle;

public class EnchancedClassLoader
extends ClassLoader {
    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return Class.forName(name, false, String.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.iterateBundles(name);
        }
    }

    private final Class<?> iterateBundles(String name) throws ClassNotFoundException {
        Bundle[] bundleArray = Activator.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getState() == 32 || bundle.getState() == 4) {
                try {
                    return bundle.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            ++n2;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            URL url = Activator.locate(name);
            return url != null ? url.openStream() : super.getResourceAsStream(name);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

