/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.auth.module.basic;

import com.sap.security.auth.util.CacheEntry;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockedUserCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockedUserCache.class);
    private int expirationTimeSec = 300;
    private long lastCleanupExecutionTime = 0L;
    private long minTimeBetweenCleanups = 15000L;
    private Map<String, CacheEntry<Integer>> cacheEntries = new ConcurrentHashMap<String, CacheEntry<Integer>>();

    public LockedUserCache() {
    }

    LockedUserCache(int expirationTimeSec, int minTimeBetweenCleanups) {
        this.expirationTimeSec = expirationTimeSec;
        this.minTimeBetweenCleanups = minTimeBetweenCleanups;
    }

    public void addEntry(String element) {
        CacheEntry<Integer> cacheEntry = this.cacheEntries.get(element);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry<Integer>(1);
            cacheEntry.setValidityPeriodInSeconds(this.expirationTimeSec);
            this.cacheEntries.put(element, cacheEntry);
        }
    }

    public void updateEntry(String element) {
        CacheEntry<Integer> cacheEntry = this.cacheEntries.get(element);
        if (cacheEntry != null) {
            int content = cacheEntry.getContent();
            cacheEntry.setContent(++content);
        }
    }

    public CacheEntry<Integer> getEntry(String element) {
        return this.cacheEntries.get(element);
    }

    public Map<String, CacheEntry<Integer>> cleanInvalidCacheEntries() {
        long timeSinceLastRun = System.currentTimeMillis() - this.lastCleanupExecutionTime;
        if (timeSinceLastRun < this.minTimeBetweenCleanups) {
            LOGGER.debug("Only {} milliseconds passed since the last execution. Skipping cleanup run.", (Object)timeSinceLastRun);
            return null;
        }
        this.lastCleanupExecutionTime = System.currentTimeMillis();
        LinkedHashMap<String, CacheEntry<Integer>> expiredCacheEntries = new LinkedHashMap<String, CacheEntry<Integer>>();
        Set<String> keys = this.cacheEntries.keySet();
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String entryKey = iterator.next();
            CacheEntry<Integer> cacheEntry = this.cacheEntries.get(entryKey);
            if (cacheEntry == null || cacheEntry.isValid()) continue;
            iterator.remove();
            expiredCacheEntries.put(entryKey, cacheEntry);
        }
        return expiredCacheEntries;
    }
}

