/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.auth.module.basic;

import com.sap.core.jpaas.security.um.service.AccountSpecificEntity;
import com.sap.core.jpaas.security.um.service.UserProviderAccessor;
import com.sap.core.jpaas.security.utils.AuditLogUtil;
import com.sap.core.jpaas.security.utils.otp.PasscodeChecker;
import com.sap.core.jpaas.security.utils.otp.PasscodeException;
import com.sap.engine.lib.security.OTPPrincipal;
import com.sap.engine.lib.security.PasswordPrincipal;
import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.engine.lib.security.login.BaseLoginException;
import com.sap.security.auth.module.basic.LockedUserCache;
import com.sap.security.auth.util.CacheEntry;
import com.sap.security.um.service.api.exception.RemotePersistenceException;
import com.sap.security.um.user.PasswordCheckResult;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UserProvider;
import com.sap.security.um.user.ext.UserProviderEx;
import java.io.IOException;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialNotFoundException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordLoginModule
implements LoginModule {
    static final String NEW_LINE_CHARACTERS_IN_USER_NAME_ERROR_MESSAGE = "Illegal characters found in user name";
    private static final int PASSCODE_LENGTH = 6;
    private static final int MIN_PASSWORD_LENGTH = 8;
    private static final String LOGIN_CONNECTION_FAILED_HEADER_NAME = "com.sap.cloud.security.login.connection.failed";
    private static final String ACCOUNT_REQUEST_ATTRIBUTE_NAME = "com.sap.cloud.security.login.accountname";
    private static final String CLOUD_ADMIN_USER_PROVIDER = "cloud_admin_user_provider";
    private static final String SECOND_FACTOR_OPTION_NAME = "secondfactor";
    private static final String ADMIN_OPTION_NAME = "adminmode";
    private static final String USER_ID_CALLBACK_NAME = "User ID:";
    private static final String PASSWORD_CALLBACK_NAME = "Password: ";
    private static final Logger LOG = LoggerFactory.getLogger(PasswordLoginModule.class);
    private CallbackHandler callbackHandler = null;
    private Subject subject = null;
    private PasswordPrincipal principal = null;
    private boolean successful;
    private boolean shouldBeIgnored;
    private Boolean isPasscodeCheckEnabled;
    private boolean isAdminOptionEnabled;
    private OTPPrincipal otpPrincipal;
    private NameCallback nameCallback;
    private HttpGetterCallback accountNameCallback;
    private PasswordCallback passwordCallback;
    private String accountName;
    private static PasscodeChecker passcodeChecker = PasscodeChecker.getInstance();
    static LockedUserCache cache = new LockedUserCache();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        LOG.info("PasswordLoginModule initialize.");
        this.callbackHandler = callbackHandler;
        this.subject = subject;
        this.successful = false;
        this.shouldBeIgnored = false;
        this.isPasscodeCheckEnabled = options.get(SECOND_FACTOR_OPTION_NAME) == null ? false : Boolean.valueOf((String)options.get(SECOND_FACTOR_OPTION_NAME));
        this.isAdminOptionEnabled = options.get(ADMIN_OPTION_NAME) == null ? false : Boolean.valueOf((String)options.get(ADMIN_OPTION_NAME));
    }

    @Override
    public boolean login() throws LoginException {
        String userName;
        block9: {
            LOG.info("PasswordLoginModule login.");
            userName = null;
            if (this.handleCallbacks()) break block9;
            return false;
        }
        try {
            userName = this.handleUserName();
            char[] password = this.handlePassword(userName);
            if (this.isPasscodeCheckEnabled.booleanValue()) {
                String passcode = this.handlePasscode(password);
                this.verifyPasscode(userName, passcode);
                password = this.removePasscodeFromPassword(password);
            }
            if (this.isAdminOptionEnabled) {
                this.accountName = this.handleAccountName();
            }
            String userId = this.verifyPassword(userName, password);
            this.validateUserId(userId);
            String issuer = this.getIssuer();
            this.createPrincipals(issuer, userId);
            LOG.info("User {} is successfully authenticated with username and password.", (Object)this.principal.getName());
            this.successful = true;
            return true;
        }
        catch (PersistenceException exception) {
            this.processPersistenceException(userName, exception);
            throw new LoginException("Unexpected Error occured.");
        }
        catch (LoginException loginException) {
            throw loginException;
        }
        catch (Exception exception) {
            LOG.error(String.format("Exception occured with message: [%s]", exception.getMessage()), (Throwable)exception);
            LoginException loginException = new LoginException(exception.getMessage());
            try {
                loginException.initCause(exception);
                throw loginException;
            }
            catch (Exception exception2) {
                throw loginException;
            }
        }
    }

    private void validateUserId(String userName) {
        if (userName.contains("\n") || userName.contains("\r")) {
            throw new IllegalArgumentException(NEW_LINE_CHARACTERS_IN_USER_NAME_ERROR_MESSAGE);
        }
    }

    private void processPersistenceException(String userName, PersistenceException exception) {
        if (exception instanceof RemotePersistenceException) {
            this.addResponseHeader(LOGIN_CONNECTION_FAILED_HEADER_NAME, "true");
        }
        AuditLogUtil.auditLogMessage((String)"Unexpected error occured while checking username and password for user &param0. The error is &param1", (String[])new String[]{userName, exception.toString()}, this.getClass());
        LOG.error("Unexpected error occured while checking username and password", (Throwable)exception);
    }

    private String getIssuer() throws PersistenceException {
        String issuer;
        UserProvider userProvider = this.getUserProvider();
        if (userProvider instanceof UserProviderEx) {
            UserProviderEx userProviderEx = (UserProviderEx)userProvider;
            issuer = userProviderEx.getName();
        } else {
            issuer = userProvider.getClass().getName();
        }
        return issuer;
    }

    private void createPrincipals(String issuer, String userId) {
        this.principal = new PasswordPrincipal(userId);
        this.principal.setAuthenticationMethod("PASSWORD");
        if (issuer != null) {
            this.principal.setIssuer(issuer);
        }
        if (this.isPasscodeCheckEnabled.booleanValue()) {
            this.otpPrincipal = new OTPPrincipal(userId);
            this.otpPrincipal.setAuthenticationMethod("OTP");
        }
    }

    public String verifyPassword(String userName, char[] password) throws PersistenceException, BaseLoginException {
        CacheEntry<Integer> cacheEntry;
        Map<String, CacheEntry<Integer>> cleanedEntries = cache.cleanInvalidCacheEntries();
        if (cleanedEntries != null) {
            this.auditLogUserRemovedFromLockedCache(cleanedEntries);
        }
        if ((cacheEntry = cache.getEntry(userName)) == null) {
            String userId = this.checkPassword(userName, password);
            LOG.info("User {} provided correct password.", (Object)userName);
            return userId;
        }
        cache.updateEntry(userName);
        String message = "Your account was temporarily locked because of too many failed attempts to log on.";
        LOG.info("Found {} in locked users cache and we will not call the ID Service for a new check.", (Object)userName);
        throw new BaseLoginException(message, 21);
    }

    private void auditLogUserRemovedFromLockedCache(Map<String, CacheEntry<Integer>> cleanedEntries) {
        for (Map.Entry<String, CacheEntry<Integer>> entry : cleanedEntries.entrySet()) {
            String name = entry.getKey();
            CacheEntry<Integer> cleanedEntry = entry.getValue();
            this.auditLogLockedUser(name, cleanedEntry.getStorageTimestamp(), cleanedEntry.getContent());
        }
    }

    private void verifyPasscode(String userName, String passcode) throws LoginException {
        try {
            passcodeChecker.checkUserPasscode(userName, passcode);
        }
        catch (PasscodeException exception) {
            LOG.error("Passcode validation failed.", (Throwable)exception);
            throw new LoginException("Passcode validation failed.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private String checkPassword(String userName, char[] password) throws PersistenceException, BaseLoginException {
        try {
            userProvider = this.getUserProvider();
            if (userProvider instanceof UserProviderEx) {
                userProviderEx = (UserProviderEx)userProvider;
                passwordCheckEx = userProviderEx.checkUserPasswordEx(userName, password);
                passwordCheck = passwordCheckEx.getPasswordCheck();
                if (passwordCheck != PasswordCheckResult.PWD_OK) {
                    this.processLockedAccount(passwordCheck, userName);
                    this.processErrors(passwordCheck, userName);
                }
                var8_7 = passwordCheckEx.getUser().getName();
                return var8_7;
            }
            passwordCheck = userProvider.checkUserPassword(userName, password);
            if (passwordCheck != null) {
                this.processLockedAccount(passwordCheck, userName);
                this.processErrors(passwordCheck, userName);
            }
            var8_8 = userName;
            return var8_8;
        }
        finally {
            i = 0;
            ** while (i < password.length)
        }
lbl-1000:
        // 1 sources

        {
            password[i] = 32;
            ++i;
            continue;
        }
lbl26:
        // 1 sources

        throw new BaseLoginException("Cannot create user");
    }

    private void processLockedAccount(PasswordCheckResult passwordCheck, String userName) {
        if (this.isPasswordLockedResponse(passwordCheck)) {
            cache.addEntry(userName);
        }
    }

    private boolean isPasswordLockedResponse(PasswordCheckResult passwordCheck) {
        return passwordCheck == PasswordCheckResult.PWD_LOCKED || passwordCheck == PasswordCheckResult.PASSWORD_RESET_REQUIRED || passwordCheck == PasswordCheckResult.PWD_DISABLED;
    }

    public UserProvider getUserProvider() throws PersistenceException {
        UserProvider userProvider;
        if (this.isAdminOptionEnabled) {
            userProvider = UserProviderAccessor.getUserProvider((String)CLOUD_ADMIN_USER_PROVIDER);
            AccountSpecificEntity adminUserProvider = (AccountSpecificEntity)userProvider;
            adminUserProvider.setAccount(this.accountName);
        } else {
            userProvider = UserProviderAccessor.getUserProvider();
        }
        return userProvider;
    }

    private char[] removePasscodeFromPassword(char[] password) {
        if (password.length >= 14) {
            return Arrays.copyOfRange(password, 0, password.length - 6);
        }
        return password;
    }

    private void addResponseHeader(String headerName, String headerValue) {
        HttpSetterCallback loginRequestHeaderCallback = new HttpSetterCallback();
        loginRequestHeaderCallback.setType((byte)1);
        loginRequestHeaderCallback.setName(headerName);
        loginRequestHeaderCallback.setValue((Object)headerValue);
        try {
            this.callbackHandler.handle(new Callback[]{loginRequestHeaderCallback});
        }
        catch (Exception e) {
            LOG.error("Unable to set \"" + headerName + "\" header.", (Throwable)e);
        }
    }

    private boolean handleCallbacks() throws BaseLoginException {
        this.accountNameCallback = new HttpGetterCallback();
        this.accountNameCallback.setType((byte)13);
        this.accountNameCallback.setName(ACCOUNT_REQUEST_ATTRIBUTE_NAME);
        this.nameCallback = new NameCallback(USER_ID_CALLBACK_NAME);
        this.passwordCallback = new PasswordCallback(PASSWORD_CALLBACK_NAME, true);
        try {
            this.callbackHandler.handle(new Callback[]{this.nameCallback, this.passwordCallback, this.accountNameCallback});
        }
        catch (UnsupportedCallbackException e) {
            this.shouldBeIgnored = true;
            LOG.error("Unsupported Callback.", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            AuditLogUtil.auditLogMessage((String)"Access Denied. Exception is: &param0", (String[])new String[]{e.toString()}, this.getClass());
            LOG.error("Access Denied.", (Throwable)e);
            throw new BaseLoginException("Access Denied.", (Throwable)e, 18);
        }
        return true;
    }

    private String handleUserName() throws CredentialNotFoundException {
        String name = this.nameCallback.getName();
        if (name == null || name.trim().length() == 0) {
            this.shouldBeIgnored = true;
            LOG.info("No user name is provided.");
            throw new CredentialNotFoundException("No user identifier is provided.");
        }
        LOG.info("Provided user identifier is {}.", (Object)name);
        return name;
    }

    private char[] handlePassword(String userName) throws CredentialNotFoundException {
        char[] password = this.passwordCallback.getPassword();
        this.passwordCallback.clearPassword();
        if (password == null || password.length == 0) {
            AuditLogUtil.auditLogMessage((String)"No password is provided for user &param0. CredentialNotFoundException is thrown", (String[])new String[]{userName}, this.getClass());
            LOG.info("No password is provided.");
            throw new CredentialNotFoundException("No password is provided.");
        }
        LOG.info("Password is provided.");
        return password;
    }

    private String handlePasscode(char[] password) throws LoginException {
        String passcode = this.extractPasscodeFromPassword(password);
        if (passcode == null || passcode.trim().equals("")) {
            LOG.error("Passcode is missing.");
            throw new LoginException("Passcode is missing.");
        }
        LOG.info("Passcode is provided.");
        return passcode;
    }

    private String handleAccountName() throws LoginException {
        String accountName = (String)this.accountNameCallback.getValue();
        if (accountName == null || accountName.trim().equals("")) {
            LOG.error("Account name is missing.");
            throw new LoginException("Account name is missing.");
        }
        return accountName;
    }

    private String extractPasscodeFromPassword(char[] password) {
        String passcode = null;
        if (password.length >= 14) {
            char[] passcodeArray = Arrays.copyOfRange(password, password.length - 6, password.length);
            int i = 0;
            while (i < 6) {
                if (!Character.isDigit(passcodeArray[i])) {
                    return null;
                }
                ++i;
            }
            passcode = new String(passcodeArray);
        }
        return passcode;
    }

    private void processErrors(PasswordCheckResult passwordCheck, String name) throws BaseLoginException {
        String message = "";
        switch (passwordCheck) {
            case PWD_WRONG: {
                message = "User provided incorrect username / password combination for user " + name + ".";
                this.throwBaseLoginException(message, (byte)0);
                break;
            }
            case PWD_LOCKED: {
                message = "Your account was temporarily locked because of too many failed attempts to log on.";
                AuditLogUtil.auditLogMessage((String)(String.valueOf(message) + " There will be no logs for the next 5 minutes."), this.getClass());
                LOG.info(message);
                throw new BaseLoginException(message, 21);
            }
            case PWD_DISABLED: {
                message = "Your password has been disabled and you cannot use it for authentication.";
                this.throwBaseLoginException(message, (byte)50);
                break;
            }
            case USER_INACTIVE: {
                message = "The account for user " + name + " is still not activated.";
                this.throwBaseLoginException(message, (byte)51);
                break;
            }
            default: {
                message = "The reason for failed logon differ than all reasons we can process.";
                this.throwBaseLoginException(message, (byte)52);
            }
        }
    }

    private void auditLogLockedUser(String userName, long storageTime, int attempts) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String message = String.format("Account %s was temporarily locked because of too many failed attempts to log on. After %s we have detected %d attempts to login which were ignored.", userName, formatter.format(new Date(storageTime)), attempts);
        AuditLogUtil.auditLogMessage((String)message, this.getClass());
        LOG.info(message);
    }

    private void throwBaseLoginException(String message, byte cause) throws BaseLoginException {
        AuditLogUtil.auditLogMessage((String)message, this.getClass());
        LOG.info(message);
        throw new BaseLoginException(message, cause);
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.shouldBeIgnored) {
            if (this.successful) {
                Set<Principal> principals = this.subject.getPrincipals();
                principals.add((Principal)this.principal);
                if (this.otpPrincipal != null) {
                    principals.add((Principal)this.otpPrincipal);
                }
                LOG.info("Password principals [{}] are added to subject.", principals);
            }
            return true;
        }
        this.shouldBeIgnored = false;
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.shouldBeIgnored) {
            if (this.successful) {
                Set<Principal> principals = this.subject.getPrincipals();
                principals.remove(this.principal);
                principals.remove(this.otpPrincipal);
                LOG.info("Password principals are removed from subject.", principals);
                this.principal = null;
                this.successful = false;
            }
            return true;
        }
        this.shouldBeIgnored = false;
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (!this.shouldBeIgnored) {
            if (this.successful) {
                Set<Principal> principals = this.subject.getPrincipals();
                principals.remove(this.principal);
                principals.remove(this.otpPrincipal);
                LOG.info("Password principals are removed from subject.", principals);
                this.successful = false;
            }
            return true;
        }
        return false;
    }
}

