/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.auth.module.clientcert;

import com.sap.engine.lib.security.Principal;
import com.sap.engine.lib.security.http.HttpGetterCallback;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCertLoginModule
implements LoginModule {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCertLoginModule.class);
    private static final String CLIENT_CERT_ATTRIBUTE_NAME = "javax.servlet.request.X509Certificate";
    private Principal principal;
    private Subject subject;
    private CallbackHandler callbackHandler;

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.principal != null) {
            this.subject.getPrincipals().add((java.security.Principal)this.principal);
        }
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackhandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackhandler;
    }

    @Override
    public boolean login() throws LoginException {
        HttpGetterCallback callback = new HttpGetterCallback();
        callback.setType((byte)4);
        callback.setName(CLIENT_CERT_ATTRIBUTE_NAME);
        try {
            this.callbackHandler.handle(new Callback[]{callback});
        }
        catch (Exception e) {
            LOG.error("Unable to read client certificate from the request", (Throwable)e);
            throw new LoginException();
        }
        X509Certificate[] certs = (X509Certificate[])callback.getValue();
        if (certs == null || certs.length == 0) {
            throw new LoginException();
        }
        this.principal = new Principal(certs[0].getSubjectDN().getName());
        this.principal.setAuthenticationMethod("certificate");
        if (certs[0].getIssuerX500Principal() != null && certs[0].getIssuerX500Principal().getName() != null) {
            this.principal.setIssuer("cert_issuer:" + certs[0].getIssuerX500Principal().getName());
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }
}

