/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.auth.service;

import com.sap.core.jpaas.security.auth.service.lib.AuthenticationStack;
import com.sap.core.jpaas.security.auth.service.lib.ResourceContainer;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;

public final class ThreadAuthenticationContext {
    private static ThreadAuthenticationContext NO_CONTEXT = new ThreadAuthenticationContext();
    private static ThreadLocal<ThreadAuthenticationContext> THREAD = new InheritableThreadLocal<ThreadAuthenticationContext>();
    private ResourceContainer container = null;
    private String authenticatedPrincipal = null;
    private ThreadAuthenticationContext parentContext = null;

    private ThreadAuthenticationContext() {
    }

    private ThreadAuthenticationContext(ResourceContainer container, ThreadAuthenticationContext parentContext) {
        this.container = container;
        this.parentContext = parentContext != null ? parentContext : NO_CONTEXT;
    }

    public String getRequestedResource() {
        return this.container != null ? this.container.getRequestedResource() : null;
    }

    public AuthenticationStack getAuthenticationConfiguration() {
        return this.container != null ? this.container.getAuthenticationConfiguration() : null;
    }

    public CallbackHandler getCallbackHandler() throws LoginException {
        if (this.container != null) {
            return this.container.getCallbackHandler();
        }
        throw new LoginException("Cannot get callback handler as there is no resource container");
    }

    public CallbackHandler getCallbackHandler(String authMethod) throws LoginException {
        if (this.container != null) {
            return this.container.getCallbackHandler(authMethod);
        }
        throw new LoginException("Cannot get callback handler as there is no resource container");
    }

    public String getAuthenticatedPrincipal() {
        return this.authenticatedPrincipal;
    }

    public void setAuthenticatedPrincipal(String userName) {
        this.authenticatedPrincipal = userName;
    }

    public static ThreadAuthenticationContext getInstance() {
        ThreadAuthenticationContext tac = THREAD.get();
        return tac != null ? tac : NO_CONTEXT;
    }

    public static void enter(ResourceContainer container) {
        if (container != null) {
            ThreadAuthenticationContext tac = new ThreadAuthenticationContext(container, ThreadAuthenticationContext.getInstance());
            THREAD.set(tac);
        }
    }

    public static void exit(ResourceContainer container) {
        if (container != null) {
            ThreadAuthenticationContext tac = ThreadAuthenticationContext.getInstance();
            while (tac.container != container && tac.parentContext != NO_CONTEXT) {
                tac = tac.parentContext;
            }
            if (tac.container == container) {
                THREAD.set(tac.parentContext);
            }
        }
    }
}

