/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.auth.service;

import com.sap.core.jpaas.security.utils.umhelper.SimpleUser;
import com.sap.engine.lib.security.Principal;
import com.sap.engine.lib.security.login.SubjectWrapper;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.User;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSession {
    private static final String SESSION_KEY_SUBJECT = "com.sap.security.auth.login.Subject";
    private static final Logger LOG = LoggerFactory.getLogger(UserSession.class);
    private static ThreadLocal<UserSession> THREAD = new InheritableThreadLocal<UserSession>(){

        @Override
        protected UserSession childValue(UserSession initial) {
            if (initial != null) {
                if (initial.request != null) {
                    return new UserSession(initial.request.getSession(false), initial.request.getRemoteUser(), null);
                }
                return new UserSession(initial.session, initial.remoteUser, null);
            }
            return null;
        }
    };
    private HttpServletRequest request = null;
    private HttpSession session = null;
    private String remoteUser = null;
    private User user = null;

    private UserSession(HttpServletRequest request) {
        this.request = request;
    }

    private UserSession(HttpSession session, String remoteUser) {
        this.session = session;
        this.remoteUser = remoteUser;
    }

    private UserSession(String remoteUser) {
        this(null, remoteUser);
        this.user = new SimpleUser(remoteUser);
    }

    private UserSession(User user) {
        this.user = user;
    }

    public static void initialize(HttpServletRequest request) {
        THREAD.set(new UserSession(request));
    }

    public static void initialize(String userName) {
        THREAD.set(new UserSession(userName));
    }

    public static void initialize(User user) {
        THREAD.set(new UserSession(user));
    }

    public static UserSession getInstance() {
        UserSession userSession = THREAD.get();
        if (userSession == null) {
            userSession = new UserSession(null);
            THREAD.set(userSession);
        }
        return userSession;
    }

    public static void removeInstance() {
        THREAD.remove();
    }

    public final String getAuthenticatedPrincipalName() {
        String userName = null;
        userName = this.getUserNameFromSubject();
        if (userName == null) {
            userName = this.remoteUser;
        }
        return userName;
    }

    private String getUserNameFromSubject() {
        java.security.Principal principal;
        String userName = null;
        SubjectWrapper subject = (SubjectWrapper)this.getSubject();
        if (subject != null && (principal = subject.getPrincipal()) != null) {
            userName = principal.getName();
        }
        return userName;
    }

    public final String getPrincipalUssuerName() {
        java.security.Principal principal;
        String name = "";
        SubjectWrapper subject = (SubjectWrapper)this.getSubject();
        if (subject != null && (principal = subject.getPrincipal()) != null && principal instanceof Principal) {
            name = ((Principal)principal).getIssuer();
        }
        return name;
    }

    public final User getCurrentUser() {
        User toReturn = this.getCurrentUserFromSubject();
        if (toReturn == null) {
            return this.user;
        }
        return toReturn;
    }

    private User getCurrentUserFromSubject() {
        SubjectWrapper subject = (SubjectWrapper)this.getSubject();
        if (subject != null) {
            try {
                java.security.Principal principal = subject.getPrincipal();
                if (principal != null) {
                    return UserManagementAccessor.getUserProvider().getUser(principal.getName());
                }
            }
            catch (PersistenceException e) {
                LOG.error("User account " + subject.getPrincipal().getName() + " not accessible", (Throwable)e);
            }
        }
        return null;
    }

    public final java.security.Principal getPrincipal(Class<? extends java.security.Principal> classs) {
        Set<? extends java.security.Principal> principals;
        SubjectWrapper subject = (SubjectWrapper)this.getSubject();
        if (subject != null && !(principals = subject.getSubject().getPrincipals(classs)).isEmpty()) {
            return principals.iterator().next();
        }
        return null;
    }

    public Object getSubject() {
        HttpSession session;
        HttpSession httpSession = session = this.request != null ? this.request.getSession(false) : this.session;
        if (session != null) {
            return this.getSessionAttribute(session, SESSION_KEY_SUBJECT);
        }
        return null;
    }

    public void setSubject(Object subject) {
        HttpSession session;
        HttpSession httpSession = session = this.request != null ? this.request.getSession(false) : this.session;
        if (session != null) {
            this.setSessionAttribute(session, SESSION_KEY_SUBJECT, subject);
        }
    }

    public Object getAttribute(String key) {
        HttpSession session;
        HttpSession httpSession = session = this.request != null ? this.request.getSession(false) : this.session;
        if (session != null) {
            LOG.info("Get attribute " + key + " from the current HTTP session.");
            return this.getSessionAttribute(session, key);
        }
        LOG.info("No HTTP session to get attribute from.");
        return null;
    }

    public String getRequestServerName() {
        String requestServerName;
        String string = requestServerName = this.request != null ? this.request.getServerName() : null;
        if (requestServerName == null) {
            LOG.info("Returned server name from current request is null.");
        }
        return requestServerName;
    }

    public void setAttribute(String key, Object value) {
        HttpSession session;
        HttpSession httpSession = session = this.request != null ? this.request.getSession(false) : this.session;
        if (session != null) {
            this.setSessionAttribute(session, key, value);
            LOG.info("Set attribute " + key + " in the current HTTP session.");
        } else {
            LOG.info("No HTTP session to store attribute in.");
        }
    }

    public void logoutCurrentSession() {
        HttpSession session;
        LOG.info("Invalidating current HTTP session.");
        HttpSession httpSession = session = this.request != null ? this.request.getSession(false) : this.session;
        if (session != null) {
            session.invalidate();
            LOG.info("Current HTTP session is invalidated.");
        } else {
            LOG.info("No HTTP session to invalidate.");
        }
    }

    private Object getSessionAttribute(HttpSession session, String attrName) {
        try {
            return session.getAttribute(attrName);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    private void setSessionAttribute(HttpSession session, String attrName, Object attrValue) {
        try {
            session.setAttribute(attrName, attrValue);
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    /* synthetic */ UserSession(HttpSession httpSession, String string, UserSession userSession) {
        this(httpSession, string);
    }
}

