/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.auth.service.webcontainer.internal;

import com.sap.core.jpaas.security.auth.service.lib.CallbackHandlerService;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHandlerServiceLocator {
    private static final Logger LOG = LoggerFactory.getLogger(CallbackHandlerServiceLocator.class);

    public static CallbackHandlerService getCallbackHandlerService() {
        LOG.debug("Searching for callback handler service in registered java services");
        ServiceLoader<CallbackHandlerService> loader = ServiceLoader.load(CallbackHandlerService.class, CallbackHandlerServiceLocator.class.getClassLoader());
        Iterator<CallbackHandlerService> iterator = loader.iterator();
        CallbackHandlerService service = null;
        if (!iterator.hasNext()) {
            LOG.warn("No callback handler service is registered.");
        } else {
            service = iterator.next();
            int serviceCnt = 1;
            while (iterator.hasNext()) {
                ++serviceCnt;
                iterator.next();
            }
            if (serviceCnt > 1) {
                LOG.warn("More than one default callback handler service is registered. This can lead to unpredictable behaviour.");
            }
        }
        return service;
    }
}

