/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.auth.service.webcontainer.internal;

import com.sap.core.jpaas.security.auth.lib.util.RequestUtil;
import com.sap.core.jpaas.security.auth.service.TenantSessionCookieConfigration;
import com.sap.core.jpaas.security.auth.service.lib.AuthImplAccessor;
import com.sap.core.jpaas.security.auth.service.lib.AuthenticationStack;
import com.sap.core.jpaas.security.auth.service.lib.AuthenticationStackReference;
import com.sap.core.jpaas.security.auth.service.lib.CallbackHandlerService;
import com.sap.core.jpaas.security.auth.service.lib.ResourceContainer;
import com.sap.security.auth.login.LoginContextFactory;
import com.sap.security.auth.service.ThreadAuthenticationContext;
import com.sap.security.auth.service.UserSession;
import com.sap.security.auth.service.webcontainer.internal.CallbackHandlerServiceAccessor;
import com.sap.security.auth.service.webcontainer.internal.UserRealm;
import com.sap.security.um.service.api.UserSessionAccessor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.realm.RealmBase;
import org.apache.tomcat.util.http.MimeHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectAuthenticatorHelper
implements AuthImplAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(DirectAuthenticatorHelper.class);

    public void initialize(Request request, ResourceContainer resourceContainer) {
        UserSession.initialize((HttpServletRequest)request);
        UserSessionAccessor.initializeAccessor((HttpServletRequest)request);
        ThreadAuthenticationContext.enter(resourceContainer);
    }

    public void cleanup(ResourceContainer resourceContainer) {
        ThreadAuthenticationContext.exit(resourceContainer);
        UserSession.removeInstance();
        UserSessionAccessor.removeSessionAccessor();
    }

    public AuthenticationStack getAuthenticationStack(String authMethod) {
        return new AuthenticationStackReference(authMethod);
    }

    public CallbackHandlerService getCallbackHandlerSservice(String authMethod) {
        return CallbackHandlerServiceAccessor.getCallbackHandlerService(authMethod);
    }

    public String getAuthenticatedPrincipal() {
        return ThreadAuthenticationContext.getInstance().getAuthenticatedPrincipal();
    }

    public String getRequestedResource() {
        return ThreadAuthenticationContext.getInstance().getRequestedResource();
    }

    public boolean shouldAddTenantCookie() {
        AuthenticationStack stack = ThreadAuthenticationContext.getInstance().getAuthenticationConfiguration();
        return stack instanceof AuthenticationStackReference;
    }

    public CallbackHandlerService getCallbackHandlerService(String authMethod) {
        return CallbackHandlerServiceAccessor.getCallbackHandlerService(authMethod);
    }

    public String getAuthMethodName() {
        AuthenticationStack stack = ThreadAuthenticationContext.getInstance().getAuthenticationConfiguration();
        if (this.isAuthenticationStackReference()) {
            AuthenticationStackReference reference = (AuthenticationStackReference)stack;
            String authMethodName = "CLIENT-CERT".equals(reference.getName()) ? "CLIENT_CERT" : reference.getName();
            return authMethodName;
        }
        return ThreadAuthenticationContext.getInstance().getRequestedResource();
    }

    private boolean isAuthenticationStackReference() {
        AuthenticationStack stack = ThreadAuthenticationContext.getInstance().getAuthenticationConfiguration();
        return stack instanceof AuthenticationStackReference;
    }

    public RealmBase getUserRealm() {
        return new UserRealm();
    }

    public Principal getPrincipal(RealmBase realm, String username) {
        if (realm instanceof UserRealm) {
            return ((UserRealm)realm).getPrincipal(username);
        }
        throw new IllegalStateException("Wrong realm instance - expected " + UserRealm.class.getName() + " but got " + realm.getClass().getName());
    }

    protected String getConfiguredBigIPCN() {
        return TenantSessionCookieConfigration.getInstance().getBigIPCN();
    }

    private boolean isTrustedTransportLayer(Request request) {
        String configuredBigIPCN;
        String certificateCN;
        block6: {
            if (!request.isSecure()) {
                LOG.debug("isTrustedTransportLayer(): request not secure");
                return false;
            }
            X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            if (certs == null || certs.length == 0 || certs[0] == null) {
                LOG.debug("isTrustedTransportLayer(): missing client certificate, request not secure");
                return false;
            }
            X500Principal subjectDN = certs[0].getSubjectX500Principal();
            try {
                List<Rdn> rdns = new LdapName(subjectDN.getName()).getRdns();
                certificateCN = null;
                configuredBigIPCN = this.getConfiguredBigIPCN();
                for (Rdn rdn : rdns) {
                    if (!"CN".equalsIgnoreCase(rdn.getType())) continue;
                    certificateCN = rdn.getValue().toString();
                    break;
                }
                if (certificateCN != null) break block6;
                LOG.warn("isTrustedTransportLayer(): a client certificate without the expected CN has been received, request not secure");
                return false;
            }
            catch (InvalidNameException e) {
                LOG.warn("isTrustedTransportLayer(): bad subject name, request not secure ", (Throwable)e);
                return false;
            }
        }
        boolean result = certificateCN.equalsIgnoreCase(configuredBigIPCN);
        LOG.debug("isTrustedTransportLayer(): configured BigIP CN: '{}', received CN: '{}'. equals ignore case? {}", new Object[]{configuredBigIPCN, certificateCN, result});
        return result;
    }

    public void validateClientCertHeader(Request request) {
        MimeHeaders headers = request.getCoyoteRequest().getMimeHeaders();
        String clientCertHeader = headers.getHeader("SSL_CLIENT_CERT");
        if (clientCertHeader != null && !(clientCertHeader = clientCertHeader.trim()).isEmpty()) {
            LOG.debug("validating received SSLClientCert header ...");
            if (!this.isTrustedTransportLayer(request)) {
                headers.removeHeader("SSL_CLIENT_CERT");
                LOG.info("Request header \"SSL_CLIENT_CERT\" has been removed because the request is not from a trusted source.");
            } else {
                LOG.debug("Request header \"SSL_CLIENT_CERT\" has been accepted because the request is from a trusted source.");
            }
        }
    }

    public void addTenantCookie(Request request, HttpServletResponse response) {
        if (!this.isAuthenticationStackReference()) {
            return;
        }
        TenantSessionCookieConfigration tenantSessionCookieConfiguration = TenantSessionCookieConfigration.getInstance();
        String tenantSessionCookieName = tenantSessionCookieConfiguration.getCookieName();
        String tenantSessionCookieValue = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (tenantSessionCookieName.equalsIgnoreCase(cookie.getName())) {
                    tenantSessionCookieValue = cookie.getValue();
                    break;
                }
                ++n2;
            }
        }
        if (tenantSessionCookieValue == null) {
            LOG.info("Tenant session cookie is missing and we are adding it: " + tenantSessionCookieName);
            try {
                tenantSessionCookieValue = TenantSessionCookieConfigration.getInstance().getRandomValue();
                Cookie tenantSessionCookie = new Cookie(tenantSessionCookieName, tenantSessionCookieValue);
                tenantSessionCookie.setPath("/");
                String tenantSessionCookieDomain = TenantSessionCookieConfigration.getInstance().getDomain(request.getServerName());
                if (tenantSessionCookieDomain != null) {
                    tenantSessionCookie.setDomain(tenantSessionCookieDomain);
                }
                tenantSessionCookie.setHttpOnly(true);
                tenantSessionCookie.setSecure(request.isSecure());
                response.addCookie(tenantSessionCookie);
            }
            catch (Exception e) {
                LOG.error("Problem while adding tenant session cookie. Problems may occur with SingleLogout later on.", (Throwable)e);
            }
        }
        HttpSession session = request.getSession(true);
        session.setAttribute(tenantSessionCookieName, tenantSessionCookieValue);
    }

    public void checkSessionConsistency(Request request) throws UnsupportedEncodingException {
        try {
            HttpSession session = request.getSession(false);
            if (session == null) {
                return;
            }
            String tenantSessionCookieName = TenantSessionCookieConfigration.getInstance().getCookieName();
            if (tenantSessionCookieName == null) {
                return;
            }
            String cookieValueFromSession = (String)session.getAttribute(tenantSessionCookieName);
            if (cookieValueFromSession == null) {
                return;
            }
            Cookie cookie = RequestUtil.getCookie((HttpServletRequest)request, (String)tenantSessionCookieName);
            if (cookie == null) {
                LOG.info("Tenant session cookie not found in request and current session will be invalidated!");
                session.invalidate();
                return;
            }
            if (!cookieValueFromSession.equals(cookie.getValue()) && !URLDecoder.decode(cookieValueFromSession, "UTF-8").equals(URLDecoder.decode(cookie.getValue(), "UTF-8"))) {
                LOG.info("Tenant session cookie not found in request and current session will be invalidated!");
                session.invalidate();
                return;
            }
        }
        catch (IllegalStateException e) {
            LOG.debug("Session invalidated while checking for consistency.", (Throwable)e);
        }
    }

    public boolean authenticate(Request request, HttpServletResponse response) throws IOException {
        response = this.getResponseFacade(response);
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("User is already authenticated with account [{}]", new Object[]{principal});
            }
            return true;
        }
        LOG.info("Triggerring authentication ...");
        try {
            LoginContext login = LoginContextFactory.createLoginContext();
            login.login();
            return !response.isCommitted();
        }
        catch (LoginException le) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Authentication failed!", (Throwable)le);
            }
            if (!response.isCommitted()) {
                response.sendError(401, "Unauthorized");
            }
            return false;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Authentication failed!", (Throwable)e);
            }
            if (!response.isCommitted()) {
                response.sendError(500, "Internal Server Error");
            }
            return false;
        }
    }

    private HttpServletResponse getResponseFacade(HttpServletResponse response) {
        if (response instanceof Response) {
            response = ((Response)response).getResponse();
        }
        return response;
    }
}

