/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.auth.service.webcontainer.internal;

import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.User;
import com.sap.security.um.user.UserProvider;
import java.security.Principal;
import org.apache.catalina.Container;
import org.apache.catalina.Wrapper;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserRealm
extends RealmBase {
    private static final Logger LOG = LoggerFactory.getLogger(UserRealm.class);

    public boolean hasRole(Wrapper wrapper, Principal principal, String role) {
        String realRole;
        if (wrapper != null && (realRole = wrapper.findSecurityReference(role)) != null) {
            role = realRole;
        }
        try {
            User user;
            UserProvider users = UserManagementAccessor.getUserProvider();
            if (users != null && (user = users.getUser(principal.getName())) != null) {
                return user.hasRole(role);
            }
        }
        catch (PersistenceException e) {
            LOG.error("User account " + principal.getName() + " cannot be accessed!", (Throwable)e);
        }
        return false;
    }

    protected String getName() {
        return "com.sap.security.auth";
    }

    protected String getPassword(String username) {
        if (username == null) {
            return null;
        }
        throw new UnsupportedOperationException("Getting of user password is not supported!");
    }

    protected Principal getPrincipal(String username) {
        if (username == null) {
            return null;
        }
        return new TomcatPrincipal(username);
    }

    public void setContainer(Container container) {
        super.setContainer(container);
        if (container.getLogger() != null) {
            this.containerLog = container.getLogger();
        }
    }

    class TomcatPrincipal
    extends GenericPrincipal {
        public TomcatPrincipal(String name) {
            super(name, null);
        }

        public String[] getRoles() {
            throw new UnsupportedOperationException("Listing of user roles is not supported!");
        }
    }
}

