/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.auth.service.webcontainer.internal.osgi;

import com.sap.core.jpaas.security.auth.service.lib.CallbackHandlerService;
import java.util.Arrays;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHandlerServiceAccessorDS {
    private static final Logger LOG = LoggerFactory.getLogger(CallbackHandlerServiceAccessorDS.class);
    private static BundleContext bundleContext = null;

    public static CallbackHandlerService getCallbackHandlerService(String authenticationMethod) {
        LOG.debug("Searching for callback handler service in registered osgi services");
        if (bundleContext == null) {
            LOG.info("CallbackHandlerServiceAccessorDS is not initialized yet");
            return null;
        }
        CallbackHandlerService service = null;
        String filter = "(authMethod=" + authenticationMethod + ")";
        try {
            ServiceReference[] serviceRefs = bundleContext.getServiceReferences(CallbackHandlerService.class.getName(), filter);
            if (serviceRefs != null && serviceRefs.length > 0) {
                if (serviceRefs.length > 1) {
                    LOG.warn("More than one CallbackHandlerService is registered for authentication method [{}]. This can lead to unpredictable behaviour.", (Object)authenticationMethod);
                }
                service = (CallbackHandlerService)bundleContext.getService(serviceRefs[0]);
                LOG.info("CallbackHandlerService [{}] has been registered for authMethod [{}] and will be used to construct CallbackHandler.", new Object[]{service.getClass().getName(), authenticationMethod});
            } else {
                LOG.info("No CallbackHandlerService is registered for authentication method [{}].", (Object)authenticationMethod);
                serviceRefs = bundleContext.getServiceReferences(CallbackHandlerService.class.getName(), null);
                if (serviceRefs != null && serviceRefs.length > 0) {
                    ServiceReference serviceReference = null;
                    String[] keys = null;
                    int countDefaultCBH = 0;
                    int i = 0;
                    while (i < serviceRefs.length) {
                        serviceReference = serviceRefs[i];
                        keys = serviceReference.getPropertyKeys();
                        if (!Arrays.asList(keys).contains("authMethod")) {
                            if (countDefaultCBH == 0) {
                                service = (CallbackHandlerService)bundleContext.getService(serviceReference);
                                LOG.info("CallbackHandlerService [{}] has been registered without authMethod property and will be used as default service.", (Object)service.getClass().getName());
                            }
                            ++countDefaultCBH;
                        }
                        ++i;
                    }
                    if (countDefaultCBH > 1) {
                        LOG.warn("More than one default callback handler service is registered. This can lead to unpredictable behaviour.");
                    }
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            LOG.info("Cannot get CallbackHandlerService from bundle context.");
        }
        return service;
    }

    public void activate(BundleContext ctx) {
        bundleContext = ctx;
    }

    public void deactivate() {
        bundleContext = null;
    }
}

