/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.auth.util;

public class CacheEntry<T> {
    private int validityPeriod = 120;
    private long storageTimestamp = System.currentTimeMillis();
    private T content;

    public CacheEntry(T content) {
        this.content = content;
    }

    public T getContent() {
        return this.content;
    }

    public void setContent(T content) {
        this.content = content;
    }

    public boolean isValid() {
        return System.currentTimeMillis() - this.storageTimestamp <= (long)this.validityPeriod * 1000L;
    }

    public void setValidityPeriodInSeconds(int i) {
        this.validityPeriod = i;
    }

    public long getStorageTimestamp() {
        return this.storageTimestamp;
    }
}

