/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.sap.core.certificate.manager.cmd.client.HttpDeleteWithBody;
import com.sap.core.certificate.manager.commons.exception.BadRequestException;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.ExceptionReceiver;
import com.sap.core.certificate.manager.commons.exception.ResourceAlreadyExistsException;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.ServiceUnavailableException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.core.certificate.manager.commons.model.CABundlesDTO;
import com.sap.core.certificate.manager.commons.model.CACertificatesDTO;
import com.sap.core.certificate.manager.commons.model.Certificate;
import com.sap.core.certificate.manager.commons.model.CertificateDTO;
import com.sap.core.certificate.manager.commons.model.CertificateInfo;
import com.sap.core.certificate.manager.commons.model.CustomDomainUrls;
import com.sap.core.certificate.manager.commons.model.CustomDomainUrlsDTO;
import com.sap.core.certificate.manager.commons.model.ProxyHostMappingDTO;
import com.sap.core.certificate.manager.commons.model.SslHost;
import com.sap.core.certificate.manager.commons.model.SslHostDTO;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class CertificateManagerRestClient {
    private static final String API_CERTIFICATES_URL = "%s/rest/customdomains/api/v1/accounts/%s/certificates";
    private static final String API_SSL_HOSTS_URL = "%s/rest/customdomains/api/v1/accounts/%s/sslhosts";
    private static final String API_PLATFORM_DOMAINS_URL = "%s/rest/platformdomains/api/v1/accounts/%s/appliances/%s/components/%s";
    static final String API_REVERSE_PROXY_URL = "%s/proxy/v1/accounts/%s/mappings";
    private static final Logger LOGGER = Logger.getLogger(CertificateManagerRestClient.class);
    private HttpClient httpClient;
    private String userName;

    public CertificateManagerRestClient(HttpClient httpClient, String userName) {
        this.httpClient = httpClient;
        this.userName = userName;
    }

    public String downloadCSR(String host, String account, String name) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/certificates/csr/%s", host, account, name);
        HttpResponse response = this.execute(new HttpGet(url));
        return EntityUtils.toString(response.getEntity());
    }

    public String generateCSR(String host, String account, CertificateInfo certificateInfo, String keysize, String algorithm, boolean force) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/certificates/csr?force=%s", host, account, force);
        if (keysize != null) {
            url = url + "&keysize=" + keysize;
        }
        if (algorithm != null) {
            url = url + "&algorithm=" + algorithm;
        }
        HttpResponse response = this.execute(new HttpPost(url), this.toJson(certificateInfo));
        return EntityUtils.toString(response.getEntity());
    }

    public void uploadCertificate(String host, String account, CertificateDTO certificate) throws IOException {
        String url = String.format(API_CERTIFICATES_URL, host, account);
        this.execute(new HttpPost(url), this.toJson(certificate));
    }

    public Collection<Certificate> listCertificates(String host, String account) throws IOException {
        String url = String.format(API_CERTIFICATES_URL, host, account);
        HttpResponse response = this.execute(new HttpGet(url));
        this.checkForError(response, 404);
        return (Collection)this.fromJson(EntityUtils.toString(response.getEntity()), new TypeToken<List<Certificate>>(){}.getType());
    }

    public void updateCertificate(String host, String account, String name, Certificate certificate) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/certificates/%s", host, account, name);
        this.execute(new HttpPut(url), this.toJson(certificate));
    }

    public void updateCertificate(String host, String account, String name, CertificateDTO certificate, boolean force) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/certificates/%s?force=%s", host, account, name, force);
        this.execute(new HttpPut(url), this.toJson(certificate));
    }

    public void uploadPublicKey(String host, String account, String name, CertificateDTO cert, boolean force) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/certificates/%s/publicKey?force=%s", host, account, name, force);
        this.execute(new HttpPut(url), this.toJson(cert));
    }

    public void addCACertificates(String host, String account, CACertificatesDTO cert) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/certificates/trustedCAs", host, account);
        this.execute(new HttpPut(url), this.toJson(cert));
    }

    public void removeBundle(String host, String account, String bundle) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/certificates/trustedCAs/%s", host, account, bundle);
        this.execute(new HttpDelete(url));
    }

    public void removeExpiredCertificatesFromBundle(String host, String account, String bundle) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/certificates/trustedCAs/%s?expired=true", host, account, bundle);
        this.execute(new HttpDelete(url));
    }

    public void removeCertificatesBySerialNumberFromBundle(String host, String account, String bundle, String serialNumbers) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/certificates/trustedCAs/%s?serialNumbers=" + serialNumbers, host, account, bundle);
        this.execute(new HttpDelete(url));
    }

    public CABundlesDTO listAllCABundles(String host, String account) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/certificates/trustedCAs?all=true", host, account);
        return this.listCABundles(url);
    }

    public CABundlesDTO listCABundlesAssignedToSslHosts(String host, String account) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/certificates/trustedCAs", host, account);
        return this.listCABundles(url);
    }

    public String getCABundleContent(String host, String account, String bundle) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/certificates/trustedCAs/%s", host, account, bundle);
        HttpResponse response = this.execute(new HttpGet(url));
        return EntityUtils.toString(response.getEntity());
    }

    private CABundlesDTO listCABundles(String url) throws IOException {
        HttpResponse response = this.execute(new HttpGet(url));
        return (CABundlesDTO)this.fromJson(EntityUtils.toString(response.getEntity()), (Type)((Object)CABundlesDTO.class));
    }

    public HttpResponse deleteCertificate(String host, String account, String name) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/certificates/%s", host, account, name);
        return this.execute(new HttpDelete(url));
    }

    public SslHost getSslHost(String host, String account, String domain) throws IOException {
        return this.getSslHost(host, account, domain, false);
    }

    public SslHost getSslHost(String host, String account, String domain, boolean listSupportedProtocols) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/sslhosts/%s?ciphers=" + listSupportedProtocols, host, account, domain);
        HttpResponse response = this.execute(new HttpGet(url));
        return (SslHost)this.fromJson(EntityUtils.toString(response.getEntity()), new TypeToken<SslHost>(){}.getType());
    }

    public int getRemainingCustomDomainsQuota(String host, String account) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/sslhosts/quotaremaining", host, account);
        HttpResponse response = this.execute(new HttpGet(url));
        String number = EntityUtils.toString(response.getEntity());
        return Integer.parseInt(number);
    }

    public int getRemainingCertificatesQuota(String host, String account) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/certificates/quotaremaining", host, account);
        HttpResponse response = this.execute(new HttpGet(url));
        String number = EntityUtils.toString(response.getEntity());
        return Integer.parseInt(number);
    }

    public Collection<SslHost> listSSlHosts(String host, String account, boolean listSupportedProtocols) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/sslhosts?ciphers=" + listSupportedProtocols, host, account, listSupportedProtocols);
        HttpResponse response = this.execute(new HttpGet(url));
        return (Collection)this.fromJson(EntityUtils.toString(response.getEntity()), new TypeToken<Collection<SslHost>>(){}.getType());
    }

    public void createSslHost(String host, String account, SslHostDTO customDomain, boolean force) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/sslhosts?force=%s", host, account, force);
        this.execute(new HttpPost(url), this.toJson(customDomain));
    }

    public void setSslHost(String host, String account, SslHostDTO customDomain) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/sslhosts/" + customDomain.getDisplayName(), host, account);
        this.execute(new HttpPut(url), this.toJson(customDomain));
    }

    public void bindCertificate(String host, String account, String domain, SslHostDTO sslHost) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/sslhosts/%s/certificate", host, account, domain);
        this.execute(new HttpPut(url), this.toJson(sslHost));
    }

    public void changeCertificate(String host, String account, String domain, SslHostDTO sslHost) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/sslhosts/%s/certificate?update=true", host, account, domain);
        this.execute(new HttpPut(url), this.toJson(sslHost));
    }

    public void unbindCertificate(String host, String account, String domain) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/sslhosts/%s/certificate", host, account, domain);
        this.execute(new HttpDelete(url));
    }

    public void mapApplicationURL(String host, String account, String domain, CustomDomainUrlsDTO appUrl, boolean force) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/sslhosts/%s/mappings?force=%s", host, account, domain, force);
        this.execute(new HttpPut(url), this.toJson(appUrl));
    }

    public String removeApplicationURLMapping(String host, String account, String domain, CustomDomainUrlsDTO appUrl) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/sslhosts/%s/mappings", host, account, domain);
        HttpResponse response = this.execute(new HttpPut(url), this.toJson(appUrl));
        return EntityUtils.toString(response.getEntity());
    }

    public List<CustomDomainUrls> getAllCustomDomainURLs(String host, String account) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/sslhosts/mappings", host, account);
        HttpResponse response = this.execute(new HttpGet(url));
        String respBody = EntityUtils.toString(response.getEntity());
        return (List)this.fromJson(respBody, new TypeToken<Collection<CustomDomainUrls>>(){}.getType());
    }

    public void deleteSslHost(String host, String account, String name) throws IOException {
        String url = String.format("%s/rest/customdomains/api/v1/accounts/%s/sslhosts/%s", host, account, name);
        this.execute(new HttpDelete(url));
    }

    public String addPlatformDomain(String host, String account, String appliance, String component, String domain) throws IOException {
        if (component == null || component.isEmpty()) {
            component = "web";
        }
        String url = String.format(API_PLATFORM_DOMAINS_URL, host, account, appliance, component);
        HttpResponse response = this.execute(new HttpPost(url), this.toJson(new String[]{domain}));
        return EntityUtils.toString(response.getEntity());
    }

    public String removePlatformDomain(String host, String account, String appliance, String component, String domain) throws IOException {
        if (component == null || component.isEmpty()) {
            component = "web";
        }
        String url = String.format(API_PLATFORM_DOMAINS_URL, host, account, appliance, component);
        HttpResponse response = this.execute(new HttpDeleteWithBody(url), this.toJson(new String[]{domain}));
        return EntityUtils.toString(response.getEntity());
    }

    public List<String> listPlatformDomains(String host, String account, String appliance, String component) throws IOException {
        if (component == null || component.isEmpty()) {
            component = "web";
        }
        String url = String.format(API_PLATFORM_DOMAINS_URL, host, account, appliance, component);
        HttpResponse response = this.execute(new HttpGet(url));
        String respBody = EntityUtils.toString(response.getEntity());
        return (List)this.fromJson(respBody, new TypeToken<List<String>>(){}.getType());
    }

    public List<String> listCustommDomains(String host, String account, String appliance, String component) throws IOException {
        if (component == null || component.isEmpty()) {
            component = "web";
        }
        String url = String.format("%s/rest/platformdomains/api/v1/accounts/%s/appliances/%s/components/%s/customdomains", host, account, appliance, component);
        HttpResponse response = this.execute(new HttpGet(url));
        String respBody = EntityUtils.toString(response.getEntity());
        return (List)this.fromJson(respBody, new TypeToken<List<String>>(){}.getType());
    }

    public void mapProxyHost(String host, String account, String applicationHost, String proxy) throws IOException {
        ProxyHostMappingDTO dto = new ProxyHostMappingDTO(proxy, applicationHost);
        String url = String.format(API_REVERSE_PROXY_URL, host, account);
        this.execute(new HttpPost(url), this.toJson(dto));
    }

    public void unmapProxyHost(String host, String account, String guid) throws IOException {
        String url = String.format("%s/proxy/v1/accounts/%s/mappings/%s", host, account, guid);
        this.execute(new HttpDelete(url));
    }

    public List<ProxyHostMappingDTO> listProxyHostMappings(String host, String account) throws IOException {
        String url = String.format(API_REVERSE_PROXY_URL, host, account);
        HttpResponse response = this.execute(new HttpGet(url));
        String respBody = EntityUtils.toString(response.getEntity());
        return (List)this.fromJson(respBody, new TypeToken<List<ProxyHostMappingDTO>>(){}.getType());
    }

    public List<ProxyHostMappingDTO> listProxyHostMappings(String host, String account, String applicationHost) throws IOException {
        String url = String.format("%s/proxy/v1/accounts/%s/mappings?applicationUrl=%s", host, account, applicationHost);
        HttpResponse response = this.execute(new HttpGet(url));
        String respBody = EntityUtils.toString(response.getEntity());
        return (List)this.fromJson(respBody, new TypeToken<List<ProxyHostMappingDTO>>(){}.getType());
    }

    public List<ProxyHostMappingDTO> listProxyHostMappings(String host, String account, String applicationHost, String proxy) throws IOException {
        String url = String.format("%s/proxy/v1/accounts/%s/mappings?applicationUrl=%s&proxyUrl=%s", host, account, applicationHost, proxy);
        HttpResponse response = this.execute(new HttpGet(url));
        String respBody = EntityUtils.toString(response.getEntity());
        return (List)this.fromJson(respBody, new TypeToken<List<ProxyHostMappingDTO>>(){}.getType());
    }

    protected HttpResponse execute(HttpEntityEnclosingRequestBase request, String body) throws IOException {
        if (body != null && !body.isEmpty()) {
            StringEntity entity = new StringEntity(body);
            request.setEntity(entity);
        }
        request.setHeader("Content-Type", "application/json");
        HttpResponse response = this.httpClient.execute(request);
        this.checkForError(response, 200, 201, 204);
        return response;
    }

    protected HttpResponse execute(HttpRequestBase request) throws IOException {
        request.setHeader("Content-Type", "application/json");
        HttpResponse response = this.httpClient.execute(request);
        this.checkForError(response, 200, 201, 204);
        return response;
    }

    private void checkForError(HttpResponse response, int ... acceptedStatusCodes) {
        if (this.errorOccured(response, acceptedStatusCodes)) {
            this.handleError(response);
        }
    }

    protected String toJson(Object data) {
        return new Gson().toJson(data);
    }

    protected <T> T fromJson(String json, Type t) {
        return this.getGson().fromJson(json, t);
    }

    private Gson getGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)Date.class), new JsonDeserializer<Date>(){

            @Override
            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new Date(Long.parseLong(json.getAsJsonPrimitive().getAsString()));
            }
        });
        return builder.create();
    }

    private boolean errorOccured(HttpResponse response, int ... acceptedStatusCodes) {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            return !this.isCodeAccepted(statusCode, acceptedStatusCodes);
        }
        return false;
    }

    private boolean isCodeAccepted(int statusCode, int ... acceptedStatusCodes) {
        for (int code : acceptedStatusCodes) {
            if (code != statusCode) continue;
            return true;
        }
        return false;
    }

    private void handleError(HttpResponse response) {
        String errorEntity;
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode == 400) {
            String errorEntity2 = this.getResponseEntity(response);
            throw new BadRequestException(errorEntity2);
        }
        if (responseCode == 401) {
            throw new UnauthorizedException();
        }
        if (responseCode == 404) {
            throw new ResourceNotFoundException();
        }
        if (responseCode == 409) {
            throw new ResourceAlreadyExistsException();
        }
        if (responseCode == 503) {
            throw new ServiceUnavailableException("The requested service is not available! Please try again later!");
        }
        if (responseCode == 500) {
            errorEntity = this.getResponseEntity(response);
            LOGGER.error("Server reported error! Entity is: " + errorEntity);
            if (!this.isJSONResponse(response)) {
                this.handleNonJsonError(errorEntity);
            }
        } else {
            throw new CertManagerException("Unexpected response code from server! Code: " + responseCode);
        }
        this.handleJsonError(errorEntity);
    }

    private String getResponseEntity(HttpResponse response) {
        try {
            return EntityUtils.toString(response.getEntity());
        }
        catch (IOException e) {
            throw new CertManagerException("Error occurred while handling error!", e);
        }
    }

    private void handleJsonError(String errorEntity) {
        ExceptionReceiver serverError = (ExceptionReceiver)this.fromJson(errorEntity, (Type)((Object)ExceptionReceiver.class));
        serverError.receiveException();
    }

    private void handleNonJsonError(String errorEntity) {
        throw new CertManagerException("Unexpected server error! Code: 500! Entity: " + errorEntity);
    }

    private boolean isJSONResponse(HttpResponse response) {
        Header[] headers = response.getHeaders("Content-Type");
        return headers.length > 0 && headers[0].getValue().startsWith("application/json");
    }
}

