/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.AppUrlMappingException;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.ResourceAlreadyExistsException;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.core.certificate.manager.commons.model.CustomDomainUrlsDTO;
import com.sap.core.certificate.manager.commons.util.UrlUtil;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

@Parameters(commandDescription="Adds a custom domain to an application URL")
public class AddCustomDomainCommand
extends BaseConsoleCommand {
    @Parameter(names={"-l", "--ssl-host"}, description="SSL host name (as defined with --name parameter when created, or 'default' if not specified on create)")
    private String sslHostName;
    @Parameter(names={"-e", "--custom-domain"}, description="Custom domain for accessing the application. Should be domain name like mydomain.com, shop.mydomain.com, etc.")
    private String customAppUrl;
    @Parameter(names={"-i", "--application-url"}, description="The URL (access point) of the application on SAP Cloud Platform default domains (aka hana.ondemand.com, etc.)")
    private String platformAppUrl;
    @Parameter(names={"-f", "--force"}, description="Force")
    private boolean force;
    @Parameter(names={"--disable-application-url"}, description="Allows you to disable access to platform URL for subscribed applications  i.e. https://<application_name><provider_subaccount>-<consumer_subaccount>.<domain>.\n\t\t\t       If you do not explicitly use this parameter, your subscribed application will continue to be accessible via its platform URL.")
    private boolean disablePlatformAppUrl;

    @Override
    public String getName() {
        return "add-custom-domain";
    }

    @Override
    public String getGroup() {
        return "application-domains";
    }

    @Override
    public void run() throws CommandException {
        this.checkParameters();
        this.convertUrlsToHostNames();
        this.dumpParameters();
        try {
            CustomDomainUrlsDTO urlMapping = new CustomDomainUrlsDTO();
            urlMapping.setCustomUrl(this.customAppUrl);
            urlMapping.setPlatformUrl(this.platformAppUrl);
            urlMapping.setSslHostDisplayName(this.sslHostName);
            if (this.disablePlatformAppUrl) {
                urlMapping.setDisablePlatformUrlForSubscription(this.disablePlatformAppUrl);
            }
            this.getRestClient().mapApplicationURL(this.host, this.account, this.sslHostName, urlMapping, this.force);
            System.out.println(String.format("Custom domain '%s' set for application '%s'", this.customAppUrl, this.platformAppUrl));
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (ResourceNotFoundException e) {
            throw new CommandException(this.getSslHostNotFoundErrorMsg(this.sslHostName), 211);
        }
        catch (ResourceAlreadyExistsException e) {
            throw new CommandException("Custom domain '" + this.customAppUrl + "' already mapped; unmap and try again", 211);
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (AppUrlMappingException e) {
            LOGGER.error("Backend error:", e);
            throw new CommandException(e.getMessage(), 215);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 215);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation error:", e);
            throw new CommandException(e.getCause(), 166);
        }
        catch (IOException e) {
            LOGGER.error("Communication error:", e);
            throw new CommandException("Problem with connection to server, please try again.", 166);
        }
        catch (Exception e) {
            LOGGER.error("General error:", e);
            throw new HelpException("Cannot do mapping; make sure the parameters are correct and try again.", 166);
        }
    }

    private void convertUrlsToHostNames() {
        this.platformAppUrl = UrlUtil.getURLWithHostToLowerCase(this.platformAppUrl);
        this.customAppUrl = UrlUtil.getURLWithHostToLowerCase(this.customAppUrl);
    }

    private void checkParameters() {
        Object[] sslHostNameDetails = new Object[]{"--ssl-host", this.sslHostName, 240};
        String[] customAppUrlDetails = new String[]{"--custom-domain", this.customAppUrl};
        String[] platformAppUrlDetails = new String[]{"--application-url", this.platformAppUrl};
        String[][] urlParameters = new String[][]{customAppUrlDetails, platformAppUrlDetails};
        ParameterValidator validator = new ParameterValidator();
        validator.validateLength("--account", this.account, 30);
        validator.validateWithSpecialCharacter(sslHostNameDetails);
        validator.validateURL(urlParameters);
        if (!UrlUtil.isValidCustomDomain(this.customAppUrl)) {
            throw new ValidationException("Invalid custom domain '" + this.customAppUrl + "'; please provide correct domain value without path. For example: mydomain.com or shop.mydomain.com", 166);
        }
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account, "ssl-host", this.sslHostName, "custom-domain", this.customAppUrl, "application-url", this.platformAppUrl, "force", this.force, "disable-application-url", this.disablePlatformAppUrl);
        DumpHelper.dumpOperationList(this.user, "Map a custom domain to an application URL.", argsList.toArray());
    }
}

