/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.BaseConsoleCommand;
import com.sap.core.certificate.manager.cmd.commands.validators.ParameterValidator;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.exception.PlatformDomainException;
import com.sap.core.certificate.manager.commons.exception.ResourceAlreadyExistsException;
import com.sap.core.certificate.manager.commons.exception.ResourceNotFoundException;
import com.sap.core.certificate.manager.commons.exception.TechnicalMalfunctionException;
import com.sap.core.certificate.manager.commons.exception.UnauthorizedException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.exception.SecurityException;
import com.sap.jpaas.infrastructure.console.exception.ValidationException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

@Parameters(commandDescription="Adds a platform domain (under hana.ondemand.com) on which the application will be accessed")
public class AddPlatformDomainCommand
extends BaseConsoleCommand {
    @Parameter(names={"-b", "--application"}, description="Name of the application you want to manage, configure, or deploy")
    private String application;
    @Parameter(names={"-c", "--component"}, description="Component", hidden=true)
    private String component = "web";
    @Parameter(names={"-m", "--platform-domain"}, description="Platform domain (under hana.ondemand.com). The chosen platform domain will be parent domain in the absolute application domain. Platform domains available for your subaccount: \nsvc.hana.ondemand.com\ncert.hana.ondemand.com")
    private String domain;

    @Override
    public String getName() {
        return "add-platform-domain";
    }

    @Override
    public String getGroup() {
        return "application-domains";
    }

    @Override
    public void run() throws CommandException {
        this.checkParameters();
        this.dumpParameters();
        try {
            String result = this.getRestClient().addPlatformDomain(this.host, this.account, this.application, this.component, this.domain);
            boolean isAdded = Boolean.parseBoolean(result);
            if (isAdded) {
                System.out.println(String.format("Domain '%s' added successfully", this.domain));
            } else {
                System.out.println(String.format("Domain '%s' not added. Check logs for details", this.domain));
            }
        }
        catch (UnauthorizedException e) {
            throw new SecurityException("Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n", 110);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (ResourceNotFoundException e) {
            throw new CommandException(e.getMessage(), 211);
        }
        catch (ResourceAlreadyExistsException e) {
            throw new CommandException("Platform domain '" + this.domain + "' already exist; choose another platform domain", 211);
        }
        catch (PlatformDomainException e) {
            throw new CommandException(e.getMessage(), 210);
        }
        catch (TechnicalMalfunctionException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 214);
        }
        catch (CertManagerException e) {
            this.proccessCertManagerException(e, "Technical error occurred; provide logs to SAP support.", 215);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation error:", e);
            throw new CommandException(e.getCause(), 166);
        }
        catch (IOException e) {
            LOGGER.error("Communication error:", e);
            throw new CommandException("Problem with connection to server, please try again.", 166);
        }
        catch (Exception e) {
            LOGGER.error("Error:", e);
            throw new HelpException("Cannot add platform domain; make sure the parameters are correct and try again.", 166);
        }
    }

    private void checkParameters() {
        ParameterValidator validator = new ParameterValidator();
        validator.validateLength("--account", this.account, 30);
        validator.validateLength("--application", this.application, 30);
        validator.validateWithSpecialCharacter(new Object[]{"--platform-domain", this.domain, 240});
        if (this.component == null || this.component.isEmpty()) {
            this.component = "web";
        }
    }

    private void dumpParameters() {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "host", this.host, "subaccount", this.account, "application", this.application, "domain", this.domain);
        DumpHelper.dumpOperationList(this.user, "Add a platform domain", argsList.toArray());
    }
}

