/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameter;
import com.sap.core.certificate.manager.cmd.client.CertificateManagerRestClient;
import com.sap.core.certificate.manager.cmd.client.FileIO;
import com.sap.core.certificate.manager.commons.exception.CertManagerException;
import com.sap.core.certificate.manager.commons.model.ClientCertCfgModeEnum;
import com.sap.core.certificate.manager.commons.model.SslHost;
import com.sap.jpaas.infrastructure.console.command.RemoteCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import org.apache.log4j.Logger;

public abstract class BaseConsoleCommand
extends RemoteCommand {
    public static final String NONE = "<none>";
    protected static final Logger LOGGER = Logger.getLogger(BaseConsoleCommand.class);
    public static final String CUSTOM_SSL_COMMAND_GROUP_NAME = "custom-ssl";
    public static final String APPLICATION_DOMAINS_COMMAND_GROUP_NAME = "application-domains";
    public static final String PARAM_SHORT_NAME = "-n";
    public static final String PARAM_SHORT_SSL_HOST_NAME = "-l";
    public static final String PARAM_SHORT_CERTIFICATE_NAME = "-c";
    public static final String PARAM_SHORT_CERTIFICATE_DN = "-d";
    public static final String PARAM_SHORT_FILE_NAME = "-f";
    public static final String PARAM_SHORT_LOCATION = "-l";
    public static final String PARAM_SHORT_LOCATION_KEY = "-k";
    public static final String PARAM_SHORT_FORCE = "-f";
    public static final String PARAM_SHORT_ALTNAME = "-s";
    public static final String PARAM_SHORT_APP_CUSTOM_URL = "-e";
    public static final String PARAM_SHORT_APP_PLATFORM_URL = "-i";
    public static final String PARAM_SHORT_KEYSIZE = "-k";
    public static final String PARAM_SHORT_SIGNATURE_ALGORITHM = "-g";
    public static final String PARAM_SHORT_SUPPORTED_PROTOCOLS = "-t";
    private static final String PARAM_LONG_ALL_ARTIFACTS = "--all";
    public static final String PARAM_LONG_CERTIFICATE_NAME = "--certificate";
    public static final String PARAM_LONG_SSL_HOST_NAME = "--ssl-host";
    public static final String PARAM_LONG_NAME = "--name";
    public static final String PARAM_LONG_CERTIFICATE_DN = "--certificate-distinguished-name";
    public static final String PARAM_LONG_FILE_NAME = "--file-name";
    public static final String PARAM_LONG_LOCATION = "--location";
    public static final String PARAM_LONG_LOCATION_KEY = "--key-location";
    public static final String PARAM_LONG_FORCE = "--force";
    public static final String PARAM_LONG_ALTNAME = "--subject-alternative-name";
    public static final String PARAM_LONG_APP_CUSTOM_URL = "--custom-domain";
    public static final String PARAM_LONG_APP_PLATFORM_URL = "--application-url";
    public static final String PARAM_LONG_KEYSIZE = "--key-size";
    public static final String PARAM_LONG_SIGNATURE_ALGORITHM = "--signature-algorithm";
    public static final String PARAM_LONG_SUPPORTED_PROTOCOLS = "--supported-protocols ";
    public static final String PARAM_LONG_BUNDLE_NAME = "--bundle";
    public static final String PARAM_LONG_ALL_BUNDLES = "--all";
    public static final String PARAM_LONG_CA_BUNDLE = "--ca-bundle";
    public static final String PARAM_LONG_DISABLE_APP_PLATFORM_URL = "--disable-application-url";
    public static final String SSL_HOST_NOT_FOUND_MSG = "SSL host '%s' does not exist in subaccount '%s'";
    public static final String HINT_SSL_HOST_NOT_FOUND = "Hint: List the available SSL Hosts in subaccount '%s' with the list-ssl-hosts command or create SSL host '%s' with create-ssl-host command.";
    public static final String PARAM_DESCRIPTION_CERTIFICATE_NAME_LONG = "Unique identifier of the certificate. It can contain alphanumerics, '-' and '_'.";
    public static final String PARAM_DESCRIPTION_CERTIFICATE_NAME = "Name of the certificate that you set to the ssl host; must be already uploaded.";
    public static final String PARAM_DESCRIPTION_CERTIFICATE_NAME_TO_CONFIGURE = "(optional) Name of the domain certificate to bind to the ssl host; must be already uploaded. Replaces the previously bound certificate.";
    public static final String PARAM_DESCRIPTION_SSL_HOST_NAME = "SSL host name (as defined with --name parameter when created, or 'default' if not specified on create)";
    public static final String PARAM_DESCRIPTION_SSL_HOST_NAME_TO_CONFIGIURE = "Name of the ssl host that will be configured.";
    public static final String PARAM_DESCRIPTION_SSL_HOST_DISPLAY_NAME = "Unique identifier of the ssl host. The value must start with a letter and can only contain 'a' - 'z' 'A' - 'Z' '0' - '9' \"_\" and \"-\". If not specified, 'default' value is set.";
    public static final String PARAM_DESCRIPTION_CERTIFICATE_DN = "Attributes of the CSR; formatted as type0=value0,type1=value1,type2=..., characters may be escaped by \\ (backslash), no spaces are skipped.\n \t\tAllowed attributes:\n\t\t\t    C=  Country  GB \n\t\t\t    ST=  State  London \n\t\t\t    L=  Location  London \n\t\t\t    O=  Organization  Global Security \n\t\t\t    OU=  Organizational Unit  IT Department \n\t\t\t    CN=  Common Name  example.com";
    public static final String PARAM_DESCRIPTION_CERTIFICATE_UPLOAD_COMMAND = "Uploads a signed custom domain certificate using either:\n\t- the previously generated CSR via the generate-csr command\n\t  or\n\t- the corresponding private key";
    public static final String PARAM_DESCRIPTION_CERTIFICATE_NAME_UPLOAD_COMMAND = "Name of the certificate";
    public static final String PARAM_DESCRIPTION_FILE_NAME = "File name containing certificate data";
    public static final String PARAM_DESCRIPTION_FILE_NAME_KEY = "(optional) File name containing private key";
    public static final String PARAM_DESCRIPTION_ALTNAME = "Subject Alternative Names - comma separated host names of alternative base domains for this certificate";
    public static final String PARAM_DESCRIPTION_APP_CUSTOM_URL = "Custom domain for accessing the application. Should be domain name like mydomain.com, shop.mydomain.com, etc.";
    public static final String PARAM_DESCRIPTION_APP_PLATFORM_URL = "The URL (access point) of the application on SAP Cloud Platform default domains (aka hana.ondemand.com, etc.)";
    public static final String PARAM_DESCRIPTION_CSR_LOCAL_FILE = "Name of local file where to store the CSR";
    public static final String PARAM_DESCRIPTION_KEYSIZE = "The size/length of generated keypair. If not provided, the default length of 2048 is used.";
    public static final String PARAM_DESCRIPTION_SIGNATURE_ALGORITHM = "If not provided, the default algorithm is used: SHA256withRSA";
    public static final String PARAM_DESCRIPTION_SUPPORTED_PROTOCOLS = "(optional) Protocols to enable for the ssl host. Prerequisite: a domain certificate bound to the ssl host. Acceptable values: TLSV1_2, TLSV1_1, and TLSV1. Delimiter = comma (,)\n\t\t\t\tExample: --supported-protocols \"TLSV1_2,TLSV1_1\"\n\t\t\t\t         In this case, TLSV1 is disabled.";
    public static final String PARAM_DESCRIPTION_LIST_SUPPORTED_PROTOCOLS = "Shows the supported SSL protocols for SSL hosts";
    public static final String PARAM_DESCRIPTION_TRUSTED_CA_FILE_NAME = "Path to a file that contains one or more X.509 certificates of trusted CAs in PEM format.";
    public static final String PARAM_DESCRIPTION_BUNDLE_NAME = "Name of a new or existing bundle in which CAs will be added. The name of a bundle must start with a letter and can only contain 'a' - 'z' 'A' - 'Z' '0' - '9', \"_\" and \"-\". A bundle can hold up to 120 certificates.";
    public static final String PARAM_DESCRIPTION_LIST_BUNDLE = "Name of the CA bundle that you want to view. Use the parameter to view a single bundle.";
    public static final String PARAM_LONG_ALL_BUNDLES_DESCRIPTION = "Lists the names of all bundles in the subaccount.";
    public static final String PARAM_DESCRIPTION_CA_BUNDLE_LOCAL_FILE = "Path to a file where the CA bundle will be downloaded.";
    public static final String PARAM_DESCRIPTION_CA_BUNDLE = "Bundle of CA certificates and the mode for applying client cert authentication.\n\t\t\t\t\t Syntax [bundle]:[switch]. Acceptable switch values: [request|require|none]. Default:request.\n\t\t\t\t\t Example: --ca-bundle mybundle:require";
    public static final String PARAM_DESCRIPTION_DISABLE_APP_PLATFORM_URL = "Allows you to disable access to platform URL for subscribed applications  i.e. https://<application_name><provider_subaccount>-<consumer_subaccount>.<domain>.\n\t\t\t       If you do not explicitly use this parameter, your subscribed application will continue to be accessible via its platform URL.";
    public static final String CA_BUNDLE_LABEL = "CA bundle : ";
    public static final String CLIENT_CERT_CFG_MODE_LABEL = "Client cert : ";
    private static final String PREFIX_HTTPS_CERTMANAGER = "https://certmanager.";
    protected static final String PREFIX_HTTPS = "https://";
    protected static final String LINE_SEPARATOR = "---------------------------------------------------------------------";
    public static final String PARAM_SHORT_PLATFORM_DOMAINS = "-m";
    public static final String PARAM_LONG_PLATFORM_DOMAINS = "--platform-domain";
    public static final String PARAM_DESCRIPTION_PLATFORM_DOMAINS = "Platform domain (under hana.ondemand.com). The chosen platform domain will be parent domain in the absolute application domain. Platform domains available for your subaccount: \nsvc.hana.ondemand.com\ncert.hana.ondemand.com";
    public static final String PARAM_SHORT_ALL_DOMAINS = "-o";
    public static final String PARAM_LONG_ALL_DOMAINS = "--all";
    public static final String PARAM_DESCRIPTION_ALL_DOMAINS = "Show both custom and platform domains (in any)";
    public static final String CERT_MANAGER_EXCEPTION = "Technical error occurred; provide logs to SAP support.";
    protected static final String COMMON_MESSAGE_EXCEPTION = "make sure the parameters are correct and try again.";
    protected static final String IO_ERROR_MESSAGE = "Problem with connection to server, please try again.";
    public static final String INVALID_USER_MSG = "Authorization error. Check if:\n1. the subaccount name and the host are correct\n2. the provided user has rights to perform the operation in the specified subaccount\n";
    @Parameter(names={"-a", "-account", "--account"}, description="Name of the account for which you provide user and password")
    protected String account;
    private CertificateManagerRestClient certManagerRestClient;

    @Override
    public void init() throws CommandException {
        super.initWithNoPasswordCheck();
        this.initHost();
    }

    private void initHost() {
        String realHost = "";
        String prefix = PREFIX_HTTPS_CERTMANAGER;
        if (this.host.indexOf(".dev") < 0) {
            realHost = this.host.substring(PREFIX_HTTPS.length());
            this.host = prefix + realHost;
        }
    }

    @Override
    public void cleanup() throws CommandException {
    }

    @Override
    public String getGroup() {
        return CUSTOM_SSL_COMMAND_GROUP_NAME;
    }

    public CertificateManagerRestClient getRestClient() {
        if (this.certManagerRestClient == null) {
            this.certManagerRestClient = new CertificateManagerRestClient(this.getHttpClient(), this.user);
        }
        return this.certManagerRestClient;
    }

    public FileIO getFileIO(String fileName) {
        return new FileIO(fileName);
    }

    protected void proccessCertManagerException(CertManagerException e, String message, int exitCode) {
        LOGGER.error("Backend error:" + e.getMessage(), e);
        throw new CommandException(message, exitCode);
    }

    protected void printSSLHostOutput(SslHost sslHost, boolean listSupportedProtocols) {
        System.out.println(LINE_SEPARATOR);
        System.out.println("Name : " + sslHost.getDisplayName());
        System.out.println("Host : " + sslHost.getVirtualServerHostName());
        String certName = NONE;
        if (sslHost.getCert() != null) {
            certName = sslHost.getCert().getName();
        }
        System.out.println("Certificate : " + certName);
        if (listSupportedProtocols && sslHost.getSupportedProtocols() != null) {
            System.out.println("Supported protocols : " + sslHost.getSupportedProtocols().replaceAll(":", ","));
        }
        String caBundle = this.getClientCertBundleName(sslHost);
        System.out.println(CA_BUNDLE_LABEL + caBundle);
        String clientCertCfgMode = this.getClientCertCfgMode(sslHost);
        System.out.println(CLIENT_CERT_CFG_MODE_LABEL + clientCertCfgMode);
    }

    private String getClientCertBundleName(SslHost sslHost) {
        if (sslHost.getClientCertBundleName() == null || "".equals(sslHost.getClientCertBundleName())) {
            return NONE;
        }
        return sslHost.getClientCertBundleName();
    }

    private String getClientCertCfgMode(SslHost sslHost) {
        if (sslHost.getClientCertCfgMode() == null || sslHost.getClientCertCfgMode() == ClientCertCfgModeEnum.NONE) {
            return NONE;
        }
        return sslHost.getClientCertCfgMode().name().toLowerCase();
    }

    protected String getSslHostNotFoundErrorMsg(String sslHostName) {
        return String.format(SSL_HOST_NOT_FOUND_MSG, sslHostName, this.account) + "\n" + String.format(HINT_SSL_HOST_NOT_FOUND, this.account, sslHostName);
    }
}

