/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.certificate.manager.cmd.commands;

import com.beust.jcommander.Parameters;
import com.sap.core.certificate.manager.cmd.commands.ManageDomainCertificateCommand;
import com.sap.core.certificate.manager.commons.model.SslHostDTO;
import java.io.IOException;

@Parameters(commandDescription="Binds a certificate to an SSL host. The certificate must already be uploaded.")
public class BindDomainCertificateCommand
extends ManageDomainCertificateCommand {
    @Override
    public String getName() {
        return "bind-domain-certificate";
    }

    @Override
    protected void callBackend(SslHostDTO sslHost) throws IOException {
        this.getRestClient().bindCertificate(this.host, this.account, this.sslHostName, sslHost);
    }

    @Override
    protected String getSuccessMessage(SslHostDTO sslHost) {
        return String.format("Certificate '%s' bound to SSL host '%s'.", this.certificate, sslHost.getDisplayName());
    }

    @Override
    protected String getCertificateNotFoundErrorMsg() {
        return "Cannot bind certificate '" + this.certificate + "' to SSL host '" + this.sslHostName + "' because it does not exist; provide the name of an existing certificate";
    }

    @Override
    protected String getRequestNotSignedErrorMsg() {
        return "Cannot bind certificate '" + this.certificate + "' to SSL host '" + this.sslHostName + "' because it has a CSR that is not signed; you have to upload the signed certificate " + "for this CSR using the upload-domain-certificate command";
    }

    @Override
    protected String getGeneralErrorMsg() {
        return "Cannot bind certificate; ";
    }
}

